/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.launch;

import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.spongepowered.asm.launch.GlobalProperties;

public class GlobalPropertiesProxy {
    private static final MethodHandle ofMethodHandle;
    private static final MethodHandle getMethodHandle;
    private static final MethodHandle putMethodHandle;

    public static <T> T get(String key) {
        return GlobalPropertiesProxy.get(key, null);
    }

    public static <T> T get(String key, T defaultValue) {
        try {
            if (getMethodHandle == null) {
                throw new IllegalStateException("GetMethodHandle is unavailable");
            }
            Object keyObject = GlobalPropertiesProxy.getOrCreateKey(key);
            Object object = getMethodHandle.invoke(keyObject, defaultValue);
            if (object != null) {
                return (T)object;
            }
            return defaultValue;
        }
        catch (Throwable ex) {
            SledgehammerLaunch.getLogger().error("Encountered an error while getting {}: {}", (Object)key, (Object)ex);
            return defaultValue;
        }
    }

    public static void put(String key, Object value) {
        try {
            if (putMethodHandle == null) {
                throw new IllegalStateException("PutMethodHandle is unavailable");
            }
            Object keyObject = GlobalPropertiesProxy.getOrCreateKey(key);
            putMethodHandle.invoke(keyObject, value);
        }
        catch (Throwable throwable) {
            SledgehammerLaunch.getLogger().error("Encountered an error while putting {}: {}", (Object)key, (Object)throwable);
        }
    }

    private static Object getOrCreateKey(String name) throws Throwable {
        if (ofMethodHandle != null) {
            return ofMethodHandle.invoke(name);
        }
        return name;
    }

    static {
        MethodHandle putMethodHandleTemporary;
        MethodHandle getMethodHandleTemporary;
        Class<String> keyClass;
        MethodHandle ofMethodHandleTemporary;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Method ofMethod = GlobalProperties.Keys.class.getMethod("of", String.class);
            ofMethodHandleTemporary = lookup.unreflect(ofMethod);
            keyClass = GlobalProperties.Keys.class;
        }
        catch (Throwable throwable) {
            ofMethodHandleTemporary = null;
            keyClass = String.class;
        }
        try {
            Method getMethod = GlobalProperties.class.getMethod("get", keyClass, Object.class);
            getMethodHandleTemporary = lookup.unreflect(getMethod);
            Method putMethod = GlobalProperties.class.getMethod("put", keyClass, Object.class);
            putMethodHandleTemporary = lookup.unreflect(putMethod);
        }
        catch (Throwable throwable) {
            getMethodHandleTemporary = null;
            putMethodHandleTemporary = null;
        }
        ofMethodHandle = ofMethodHandleTemporary;
        getMethodHandle = getMethodHandleTemporary;
        putMethodHandle = putMethodHandleTemporary;
    }
}

