/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import com.google.common.collect.Lists;
import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.Util;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.addons.AddonForge;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.styles.ProgressStyleTOPAddonGrey;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import li.cil.oc.api.Items;
import li.cil.oc.api.component.RackMountable;
import li.cil.oc.api.machine.Machine;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.common.block.SimpleBlock;
import li.cil.oc.common.entity.Drone;
import li.cil.oc.common.tileentity.Assembler;
import li.cil.oc.common.tileentity.Charger;
import li.cil.oc.common.tileentity.Disassembler;
import li.cil.oc.common.tileentity.Printer;
import li.cil.oc.common.tileentity.Rack;
import li.cil.oc.common.tileentity.Raid;
import li.cil.oc.common.tileentity.Transposer;
import li.cil.oc.common.tileentity.Waypoint;
import li.cil.oc.common.tileentity.traits.Environment;
import li.cil.oc.server.component.FileSystem;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

@TOPAddon(dependency="opencomputers")
public class AddonOpenComputers
extends AddonBlank {
    private final int[][] CMYK = new int[][]{{-16711681, -16733526}, {-65281, -5635926}, {-256, -5592576}, {-11184811, -16777216}};

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        int serverIndex;
        RackMountable server;
        int pixelY;
        Rack rack;
        Raid raid;
        boolean analyzer = this.holdingAnalyzer(player);
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof Environment && ((Environment)tile).node() != null) {
            Disassembler disassembler;
            Assembler assembler;
            if (tile instanceof Assembler && (assembler = (Assembler)tile).isAssembling()) {
                this.progressBar(probeInfo, (int)assembler.progress(), -10040218, -12087737);
            }
            if (tile instanceof Disassembler && !(disassembler = (Disassembler)tile).func_191420_l()) {
                this.progressBar(probeInfo, (int)disassembler.progress(), -5111808, -1768444);
            }
            if (tile instanceof Charger) {
                AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:charge_speed*}", Double.toString((double)Math.round(100.0 * ((Charger)tile).chargeSpeed()) / 100.0));
            }
            if (((Environment)tile).node().reachability() != Visibility.None) {
                AddonOpenComputers.textPrefixed(probeInfo, "{*option.oc.address*}", analyzer ? ((Environment)tile).node().address() : ((Environment)tile).node().address().substring(0, 8));
            }
            if (tile instanceof Component) {
                AddonOpenComputers.textPrefixed(probeInfo, "{*option.oc.componentName*}", ((Component)tile).name());
            }
            if (tile instanceof Machine) {
                Machine machine = (Machine)tile;
                AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:connected_components*}", machine.componentCount() + "/" + machine.maxComponents());
                if (machine.lastError() != null) {
                    AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:last_error*}", "{*oc:" + machine.lastError() + "*}", TextStyleClass.ERROR);
                }
            }
        }
        if (tile instanceof Printer) {
            Printer printer = (Printer)tile;
            int[] colours = this.CMYK[(int)(4L * (world.func_72820_D() % 100L) / 100L)];
            probeInfo.progress(printer.amountMaterial(), printer.maxAmountMaterial(), (IProgressStyle)new ProgressStyleTOPAddonGrey().filledColor(-2382170).alternateFilledColor(-3109748).prefix("Material: "));
            probeInfo.progress(printer.amountInk(), printer.maxAmountInk(), (IProgressStyle)new ProgressStyleTOPAddonGrey().filledColor(colours[0]).alternateFilledColor(colours[1]).prefix("Ink: "));
            if (printer.isPrinting()) {
                IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                if (printer.data().stateOff().nonEmpty()) {
                    hori.item(printer.data().createItemStack());
                }
                this.progressBar(hori, (int)printer.progress(), -10040218, -12087737);
            }
        }
        if (tile instanceof Waypoint) {
            AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:label*}", ((Waypoint)tile).label());
        }
        if (tile instanceof Raid && !(raid = (Raid)tile).func_191420_l()) {
            AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:raid_space*}", ((FileSystem)raid.filesystem().get()).fileSystem().spaceUsed() + "/" + ((FileSystem)raid.filesystem().get()).fileSystem().spaceTotal() + " bytes");
        }
        if (tile instanceof Transposer) {
            AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:side*}", data.getSideHit().func_176610_l() + " (" + data.getSideHit().func_176745_a() + ')');
        }
        if (tile instanceof Rack && !(rack = (Rack)tile).func_191420_l() && rack.facing() == data.getSideHit() && (pixelY = (int)(8.0 - 16.0 * (data.getHitVec().field_72448_b - rack.yPosition()))) >= 2 && pixelY < 14 && (server = rack.getMountable(serverIndex = pixelY < 5 ? 0 : (pixelY < 8 ? 1 : (pixelY < 11 ? 2 : 3)))) != null) {
            IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-12285884)));
            vert.text(TextStyleClass.INFO + "{*topaddons.opencomputers:server*} " + serverIndex);
            AddonOpenComputers.textPrefixed(vert, "{*option.oc.address*}", analyzer ? server.node().address() : server.node().address().substring(0, 8));
            if (server.node().host() instanceof Machine) {
                Machine machine = (Machine)server.node().host();
                AddonOpenComputers.textPrefixed(vert, "{*topaddons.opencomputers:connected_components*}", machine.componentCount() + "/" + machine.maxComponents());
                if (machine.lastError() != null) {
                    AddonOpenComputers.textPrefixed(vert, "{*topaddons.opencomputers:last_error*}", "{*oc:" + machine.lastError() + "*}", TextStyleClass.ERROR);
                }
            }
        }
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (entity instanceof Drone) {
            Drone drone = (Drone)entity;
            if (drone.node() != null) {
                Machine machine;
                Node node = ((Drone)entity).node();
                if (Config.getRealConfig().getRFMode() == 1) {
                    probeInfo.progress(drone.globalBuffer().intValue(), drone.globalBufferSize().intValue(), probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
                } else {
                    probeInfo.text(TextStyleClass.PROGRESS + "RF: " + ElementProgress.format((long)drone.globalBuffer().intValue(), (NumberFormat)Config.rfFormat, (String)"RF"));
                }
                AddonOpenComputers.textPrefixed(probeInfo, "{*option.oc.address*}", this.holdingAnalyzer(player) ? node.address() : node.address().substring(0, 8));
                if (drone.control().tank().tankCount() > 0) {
                    for (int i = 0; i < drone.control().tank().tankCount(); ++i) {
                        AddonForge.addTankElement(probeInfo, "Tank " + (i + 1), drone.control().tank().getFluidTank(i).getInfo(), mode, player);
                    }
                }
                if (mode == ProbeMode.EXTENDED && drone.control().inventory().func_70302_i_() > 0) {
                    IInventory inventory = drone.control().inventory();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        Util.mergeItemStack(inventory.func_70301_a(i), stacks);
                    }
                    if (stacks.size() > 0) {
                        IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)));
                        int i = 0;
                        for (ItemStack stack : stacks) {
                            if (i == drone.control().selectedSlot()) {
                                int color = new Color(173, 255, 173, 255 * ((int)world.func_72820_D() % 20) / 20).hashCode();
                                hori.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(color))).item(stack, probeInfo.defaultItemStyle().width(16).height(16));
                            } else {
                                hori.item(stack);
                            }
                            ++i;
                        }
                    }
                }
                if ((machine = (Machine)node.host()).lastError() != null) {
                    AddonOpenComputers.textPrefixed(probeInfo, "{*topaddons.opencomputers:last_error*}", "{*oc:" + machine.lastError() + "*}", TextStyleClass.ERROR);
                }
            }
            if (mode == ProbeMode.EXTENDED) {
                if (((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("ocFullComponentNames")) {
                    for (ItemStack component : drone.internalComponents()) {
                        probeInfo.text('-' + component.func_82833_r());
                    }
                } else {
                    this.showItemStackRows(probeInfo, Lists.newArrayList((Iterable)drone.internalComponents()), 5);
                }
            }
        }
    }

    @Override
    public List<IBlockDisplayOverride> getBlockDisplayOverrides() {
        return Collections.singletonList((mode, probeInfo, player, world, blockState, data) -> {
            if (blockState.func_177230_c() instanceof SimpleBlock) {
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().item(data.getPickBlock()).vertical().text(data.getPickBlock().func_77953_t().field_77937_e + data.getPickBlock().func_82833_r()).text(TextStyleClass.MODNAME + Tools.getModName((Block)((ItemBlock)data.getPickBlock().func_77973_b()).func_179223_d()));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(data.getPickBlock()).text(data.getPickBlock().func_77953_t().field_77937_e + data.getPickBlock().func_82833_r());
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public List<IEntityDisplayOverride> getEntityDisplayOverrides() {
        return Collections.singletonList((mode, probeInfo, player, world, entity, data) -> {
            if (entity instanceof Drone) {
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().entity(entity).vertical().text(EnumRarity.values()[((Drone)entity).tier()].field_77937_e + ((Drone)entity).info().name()).text(TextStyleClass.MODNAME + Tools.getModName((Entity)entity));
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text(EnumRarity.values()[((Drone)entity).tier()].field_77937_e + ((Drone)entity).info().name());
                }
                return true;
            }
            return false;
        });
    }

    private boolean holdingAnalyzer(EntityPlayer player) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack itemStack = player.func_184586_b(hand);
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != Items.get((String)"analyzer").item()) continue;
            return true;
        }
        return false;
    }
}

