/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.LogHelper;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InfoHelper {
    public static final int GUI_TITLE = 65535;

    public static void addLore(ItemStack stack, List<String> list, boolean addLeadingLine) {
        String[] lore = InfoHelper.getLore(stack);
        if (addLeadingLine) {
            list.add("");
        }
        if (lore == null) {
            list.add("" + TextFormatting.ITALIC + "" + TextFormatting.DARK_PURPLE + "Invalid lore localization! (something is broken)");
            return;
        }
        Arrays.stream(lore).map(s -> "" + TextFormatting.ITALIC + "" + TextFormatting.DARK_PURPLE + s).forEachOrdered(list::add);
    }

    public static void addLore(ItemStack stack, List<String> list) {
        InfoHelper.addLore(stack, list, true);
    }

    public static void addEnergyAndLore(ItemStack stack, List<String> list) {
        if (!InfoHelper.isShiftKeyDown()) {
            list.add(MessageFormat.format("{0} {1}{2}{3}{4} {5}{6}", I18n.func_135052_a((String)"info.sm.hold.txt", (Object[])new Object[0]), TextFormatting.AQUA, TextFormatting.ITALIC, I18n.func_135052_a((String)"info.sm.shift.txt", (Object[])new Object[0]), TextFormatting.RESET, TextFormatting.GRAY, I18n.func_135052_a((String)"info.sm.forDetails.txt", (Object[])new Object[0])));
        } else {
            InfoHelper.addLore(stack, list);
        }
    }

    public static String[] getLore(ItemStack stack) {
        String unlocalizeLore = stack.func_77973_b().func_77658_a() + ".lore";
        String rawLore = I18n.func_135052_a((String)unlocalizeLore, (Object[])new Object[0]);
        if (rawLore.contains(unlocalizeLore)) {
            return null;
        }
        String lineCountS = rawLore.substring(0, 1);
        rawLore = rawLore.substring(1);
        int lineCount = 0;
        try {
            lineCount = Integer.parseInt(lineCountS);
        }
        catch (NumberFormatException e) {
            LogHelper.error("Invalid Lore Format! Lore myst start with the number of lines \"3Line 1\\nLine 2\\nLine 3\"");
        }
        String[] loreLines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            String string = loreLines[i] = rawLore.contains("\\n") ? rawLore.substring(0, rawLore.indexOf("\\n")) : rawLore;
            if (!rawLore.contains("\\n")) continue;
            rawLore = rawLore.substring(rawLore.indexOf("\\n") + 2);
        }
        return loreLines;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isCtrlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean holdShiftForDetails(List<String> list, boolean inverted) {
        if (InfoHelper.isShiftKeyDown() == inverted) {
            list.add(I18n.func_135052_a((String)"info.sc.holdShiftForDetails.txt", (Object[])new Object[]{TextFormatting.AQUA + "" + TextFormatting.ITALIC, TextFormatting.RESET + "" + TextFormatting.GRAY}));
        }
        return InfoHelper.isShiftKeyDown();
    }

    public static boolean holdShiftForDetails(List<String> list) {
        return InfoHelper.holdShiftForDetails(list, false);
    }

    public static String ITC() {
        return "" + TextFormatting.RESET + "" + TextFormatting.DARK_AQUA;
    }

    public static String HITC() {
        return "" + TextFormatting.RESET + "" + TextFormatting.ITALIC + "" + TextFormatting.GOLD;
    }
}

