/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text.feature.pagination;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.event.HoverEvent;
import me.lucko.spark.lib.adventure.text.feature.pagination.PaginationBuilder;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.Style;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface Pagination<T> {
    public static final int WIDTH = 55;
    public static final int RESULTS_PER_PAGE = 6;
    public static final char LINE_CHARACTER = '-';
    public static final Style LINE_STYLE = Style.style(NamedTextColor.DARK_GRAY);
    public static final char PREVIOUS_PAGE_BUTTON_CHARACTER = '\u00ab';
    public static final Style PREVIOUS_PAGE_BUTTON_STYLE = Style.style(NamedTextColor.RED, HoverEvent.showText(Component.text("Previous Page", (TextColor)NamedTextColor.RED)));
    public static final char NEXT_PAGE_BUTTON_CHARACTER = '\u00bb';
    public static final Style NEXT_PAGE_BUTTON_STYLE = Style.style(NamedTextColor.GREEN, HoverEvent.showText(Component.text("Next Page", (TextColor)NamedTextColor.GREEN)));
    public static final Renderer DEFAULT_RENDERER = new Renderer(){

        public String toString() {
            return "Pagination.DEFAULT_RENDERER";
        }
    };

    public static @NonNull Builder builder() {
        return new PaginationBuilder();
    }

    public @NonNull List<Component> render(@NonNull Collection<? extends T> var1, int var2);

    public static interface Builder {
        public @NonNull Builder width(int var1);

        public @NonNull Builder resultsPerPage(@NonNegative int var1);

        public @NonNull Builder renderer(@NonNull Renderer var1);

        public @NonNull Builder line(@NonNull Consumer<CharacterAndStyle> var1);

        public @NonNull Builder previousButton(@NonNull Consumer<CharacterAndStyle> var1);

        public @NonNull Builder nextButton(@NonNull Consumer<CharacterAndStyle> var1);

        public <T> @NonNull Pagination<T> build(@NonNull Component var1, @NonNull Renderer.RowRenderer<T> var2, @NonNull PageCommandFunction var3);

        public static interface CharacterAndStyle {
            public @NonNull CharacterAndStyle character(char var1);

            public @NonNull CharacterAndStyle style(@NonNull Style var1);
        }
    }

    @FunctionalInterface
    public static interface PageCommandFunction {
        public @NonNull String pageCommand(int var1);
    }

    public static interface Renderer {
        public static final Component GRAY_LEFT_ROUND_BRACKET = Component.text("(", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_LEFT_SQUARE_BRACKET = Component.text("[", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_RIGHT_ROUND_BRACKET = Component.text(")", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_RIGHT_SQUARE_BRACKET = Component.text("]", (TextColor)NamedTextColor.GRAY);
        public static final Component GRAY_FORWARD_SLASH = Component.text("/", (TextColor)NamedTextColor.GRAY);

        default public @NonNull Component renderEmpty() {
            return Component.text("No results match.", (TextColor)NamedTextColor.GRAY);
        }

        default public @NonNull Component renderUnknownPage(int page, int pages) {
            return Component.text("Unknown page selected. " + pages + " total pages.", (TextColor)NamedTextColor.GRAY);
        }

        default public @NonNull Component renderHeader(@NonNull Component title, int page, int pages) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(title)).append((Component)Component.space())).append(GRAY_LEFT_ROUND_BRACKET)).append((Component)Component.text(page, (TextColor)NamedTextColor.WHITE))).append(GRAY_FORWARD_SLASH)).append((Component)Component.text(pages, (TextColor)NamedTextColor.WHITE))).append(GRAY_RIGHT_ROUND_BRACKET)).append((Component)Component.space())).build();
        }

        default public @NonNull Component renderPreviousPageButton(char character, @NonNull Style style, @NonNull ClickEvent clickEvent) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(GRAY_LEFT_SQUARE_BRACKET)).append((Component)Component.text(character, style.clickEvent(clickEvent)))).append(GRAY_RIGHT_SQUARE_BRACKET)).append((Component)Component.space())).build();
        }

        default public @NonNull Component renderNextPageButton(char character, @NonNull Style style, @NonNull ClickEvent clickEvent) {
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append(GRAY_LEFT_SQUARE_BRACKET)).append((Component)Component.text(character, style.clickEvent(clickEvent)))).append(GRAY_RIGHT_SQUARE_BRACKET)).append((Component)Component.space())).build();
        }

        @FunctionalInterface
        public static interface RowRenderer<T> {
            public @NonNull Collection<Component> renderRow(@Nullable T var1, int var2);
        }
    }
}

