/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IIFluidTank;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.FluidKey;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.OverlayedFluidHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.fluids.IMultipleTankHandler")
@IterableSimple(value="mods.forge.fluids.IFluidTank")
@ZenRegister
public interface IIMultipleTankHandler
extends Iterable<IIFluidTank> {
    public IMultipleTankHandler getInner();

    @ZenMethod
    public IIFluidTank[] getFluidTanks();

    @ZenMethod
    public int getTanks();

    @ZenMethod
    public IIFluidTank getTankAt(int var1);

    @ZenMethod
    public int fill(ILiquidStack var1, boolean var2);

    @Nullable
    @ZenMethod
    public ILiquidStack drain(ILiquidStack var1, boolean var2);

    @Nullable
    @ZenMethod
    public ILiquidStack drain(int var1, boolean var2);

    @ZenMethod
    default public boolean addFluids(boolean simulate, List<ILiquidStack> fluidStacks) {
        IMultipleTankHandler handler = this.getInner();
        List<FluidStack> fluids = fluidStacks.stream().map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
        if (simulate) {
            OverlayedFluidHandler overlayedFluidHandler = new OverlayedFluidHandler(handler);
            Map fluidKeyMap = GTHashMaps.fromFluidCollection(fluids);
            for (Map.Entry entry : fluidKeyMap.entrySet()) {
                int amountToInsert = (Integer)entry.getValue();
                int inserted = overlayedFluidHandler.insertStackedFluidKey((FluidKey)entry.getKey(), amountToInsert);
                if (inserted == amountToInsert) continue;
                return false;
            }
            return true;
        }
        fluids.forEach(fluidStack -> handler.fill(fluidStack, true));
        return true;
    }
}

