/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.brackethandler;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.zenscript.IBracketHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCMetaTileEntity;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IMetaTileEntity;
import eutros.multiblocktweaker.helper.ReflectionHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MetaTileEntityBracketHandler
implements IBracketHandler {
    private static final IMetaTileEntity[] EMPTY = new IMetaTileEntity[0];
    private static final Map<String, IMetaTileEntity[]> cache = new HashMap<String, IMetaTileEntity[]>();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaTileEntityBracketHandler.class, (String)"get", (Class[])new Class[]{String.class});

    public static IMetaTileEntity[] get(String member) {
        if (!cache.containsKey(member)) {
            Object mte = ReflectionHelper.getStatic(MetaTileEntities.class, member);
            if (mte instanceof MetaTileEntity) {
                cache.put(member, new IMetaTileEntity[]{new MCMetaTileEntity((MetaTileEntity)mte)});
            } else if (mte instanceof MetaTileEntity[]) {
                cache.put(member, (IMetaTileEntity[])Arrays.stream((MetaTileEntity[])mte).filter(Objects::nonNull).map(MCMetaTileEntity::new).toArray(IMetaTileEntity[]::new));
            } else {
                mte = IMetaTileEntity.byId(member);
                if (mte instanceof MetaTileEntity) {
                    cache.put(member, new IMetaTileEntity[]{new MCMetaTileEntity((MetaTileEntity)mte)});
                } else {
                    cache.put(member, EMPTY);
                }
            }
        }
        return cache.get(member);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("mte")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

