/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.brackethandler;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.zenscript.IBracketHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.intellij.lang.annotations.RegExp;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler
@ZenRegister
public class MetaStateBracketHandler
implements IBracketHandler {
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaStateBracketHandler.class, (String)"getBlockState", (Class[])new Class[]{String.class, Integer.TYPE});

    @RegExp
    public String getRegexMatchingString() {
        return "metastate:.+";
    }

    public Class<crafttweaker.api.block.IBlockState> getReturnedClass() {
        return crafttweaker.api.block.IBlockState.class;
    }

    public static crafttweaker.api.block.IBlockState getBlockState(String name, int meta) {
        if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(name))) {
            CraftTweakerAPI.logError((String)("No block found with name '" + name + "'. Air block used instead."));
            return CraftTweakerMC.getBlockState((IBlockState)Blocks.field_150350_a.func_176223_P());
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null) {
            block = Blocks.field_150350_a;
        }
        IBlockState mcState = block.func_176223_P();
        for (IBlockState s : block.func_176194_O().func_177619_a()) {
            if (block.func_176201_c(s) != meta) continue;
            mcState = s;
            break;
        }
        return CraftTweakerMC.getBlockState((IBlockState)mcState);
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        BlockStateReferenceSymbol zenSymbol = null;
        String bracketString = tokens.stream().map(Token::getValue).reduce("", String::concat);
        String[] split = bracketString.split(":", 4);
        if (split.length > 1 && "metastate".equalsIgnoreCase(split[0])) {
            String blockName;
            int meta = 0;
            if (split.length > 2) {
                blockName = split[1] + ":" + split[2];
                if (split.length > 3) {
                    try {
                        meta = Integer.parseInt(split[3]);
                    }
                    catch (NumberFormatException e) {
                        CraftTweakerAPI.logError((String)String.format("Invalid integer passed for metastate bracket handler: %s", split[3]), (Throwable)e);
                    }
                }
            } else {
                blockName = split[1];
            }
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName))) {
                return null;
            }
            zenSymbol = new BlockStateReferenceSymbol(environment, blockName, meta);
        }
        return zenSymbol;
    }

    private class BlockStateReferenceSymbol
    implements IZenSymbol {
        private final IEnvironmentGlobal environment;
        private final String name;
        private final int meta;

        public BlockStateReferenceSymbol(IEnvironmentGlobal environment, String name, int meta) {
            this.environment = environment;
            this.name = name;
            this.meta = meta;
        }

        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionCallStatic(position, this.environment, MetaStateBracketHandler.this.method, new Expression[]{new ExpressionString(position, this.name), new ExpressionInt(position, (long)this.meta, (ZenType)ZenType.INT)});
        }
    }
}

