/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.event.JEDEventHandlerClient;
import fi.dy.masa.justenoughdimensions.util.ClientUtils;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSyncWorldProperties
implements IMessage {
    @Nullable
    private JsonObject jedProperties;
    private boolean hasJEDTag;
    private boolean isHardcore;

    public MessageSyncWorldProperties() {
    }

    public MessageSyncWorldProperties(World world) {
        this.isHardcore = world.func_72912_H().func_76093_s();
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists(world);
        if (props != null) {
            this.hasJEDTag = true;
            this.jedProperties = props.getJEDPropsForClientSync();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isHardcore);
        buf.writeBoolean(this.hasJEDTag);
        if (this.hasJEDTag) {
            try {
                DataOutputStream data = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream((OutputStream)new ByteBufOutputStream(buf))));
                data.writeUTF(JEDJsonUtils.serialize((JsonElement)this.jedProperties));
                data.close();
            }
            catch (IOException e) {
                JustEnoughDimensions.logger.error("MessageSyncWorldProperties.toBytes(): Failed to write the JEDWorldProperties object to ByteBuf", (Throwable)e);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.isHardcore = buf.readBoolean();
        this.hasJEDTag = buf.readBoolean();
        if (this.hasJEDTag) {
            try {
                DataInputStream data = new DataInputStream(new BufferedInputStream(new InflaterInputStream((InputStream)new ByteBufInputStream(buf))));
                JsonElement element = JEDJsonUtils.deserialize(data.readUTF());
                data.close();
                if (element != null && element.isJsonObject()) {
                    this.jedProperties = element.getAsJsonObject();
                }
            }
            catch (IOException e) {
                JustEnoughDimensions.logger.error("MessageSyncWorldProperties.fromBytes(): Failed to read from ByteBuf", (Throwable)e);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSyncWorldProperties, IMessage> {
        public IMessage onMessage(final MessageSyncWorldProperties message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                JustEnoughDimensions.logger.error("Wrong side in MessageSyncWorldProperties: " + ctx.side);
                return null;
            }
            final Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc == null) {
                JustEnoughDimensions.logger.error("Minecraft was null in MessageSyncWorldProperties");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, (World)mc.field_71441_e);
                }
            });
            return null;
        }

        protected void processMessage(MessageSyncWorldProperties message, World world) {
            world.func_72912_H().func_176119_g(message.isHardcore);
            JEDWorldProperties.setClientProperties(message.jedProperties);
            if (world.field_73011_w instanceof IWorldProviderJED) {
                ((IWorldProviderJED)world.field_73011_w).setJEDProperties(JEDWorldProperties.getClientProperties());
                JustEnoughDimensions.logInfo("MessageSyncWorldProperties - DIM: {}: Synced custom JED WorldProvider properties: {}", world.field_73011_w.getDimension(), message.jedProperties);
            } else if (ClientUtils.setRenderersFrom(world.field_73011_w, message.jedProperties)) {
                JustEnoughDimensions.logInfo("MessageSyncWorldProperties - DIM: {}: Set a customized sky/cloud/weather render type for a non-JED world", world.field_73011_w.getDimension());
            }
            JsonObject colorData = message.jedProperties != null ? JEDJsonUtils.getNestedObject(message.jedProperties, "Colors", false) : null;
            JEDEventHandlerClient.setColors(DimensionConfig.ColorType.FOLIAGE, JEDEventHandlerClient.getColorMap(colorData, DimensionConfig.ColorType.FOLIAGE));
            JEDEventHandlerClient.setColors(DimensionConfig.ColorType.GRASS, JEDEventHandlerClient.getColorMap(colorData, DimensionConfig.ColorType.GRASS));
            JEDEventHandlerClient.setColors(DimensionConfig.ColorType.WATER, JEDEventHandlerClient.getColorMap(colorData, DimensionConfig.ColorType.WATER));
            if (colorData != null) {
                JustEnoughDimensions.logInfo("MessageSyncWorldProperties - DIM: {}: Synced color data: '{}'", world.field_73011_w.getDimension(), JEDJsonUtils.serialize((JsonElement)colorData));
            }
        }
    }
}

