/*
 * Decompiled with CFR 0.152.
 */
package gregtech.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import gregtech.api.modules.GregTechModule;
import gregtech.api.modules.IGregTechModule;
import gregtech.api.modules.IModuleContainer;
import gregtech.api.modules.IModuleManager;
import gregtech.api.modules.ModuleStage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleManager
implements IModuleManager {
    private static final ModuleManager INSTANCE = new ModuleManager();
    private final Map<String, IModuleContainer> containers = new HashMap<String, IModuleContainer>();
    private final Map<ResourceLocation, IGregTechModule> sortedModules = new LinkedHashMap<ResourceLocation, IGregTechModule>();
    private final Set<IGregTechModule> loadedModules = new LinkedHashSet<IGregTechModule>();
    private IModuleContainer currentContainer;
    private ModuleStage currentStage = ModuleStage.C_SETUP;
    private final Logger logger = LogManager.getLogger((String)"GregTech Module Loader");

    private ModuleManager() {
    }

    public static ModuleManager getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isModuleEnabled(ResourceLocation id) {
        return this.sortedModules.containsKey(id);
    }

    public boolean isModuleEnabled(IGregTechModule module) {
        return true;
    }

    @Override
    public IModuleContainer getLoadedContainer() {
        return this.currentContainer;
    }

    @Override
    public ModuleStage getStage() {
        return this.currentStage;
    }

    @Override
    public boolean hasPassedStage(ModuleStage stage) {
        return this.currentStage.ordinal() > stage.ordinal();
    }

    @Override
    public void registerContainer(IModuleContainer container) {
        if (this.currentStage != ModuleStage.C_SETUP) {
            this.logger.error("Failed to register module container {}, as module loading has already begun", (Object)container);
            return;
        }
        Preconditions.checkNotNull((Object)container);
        this.containers.put(container.getID(), container);
    }

    public void setup(FMLPreInitializationEvent event) {
        this.currentStage = ModuleStage.M_SETUP;
        Map<String, List<IGregTechModule>> modules = this.getModules(event.getAsmData());
        this.configureModules(modules);
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Registering event handlers");
            for (Class<?> clazz : module.getEventBusSubscribers()) {
                MinecraftForge.EVENT_BUS.register(clazz);
            }
        }
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.currentStage = ModuleStage.PRE_INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Registering packets");
            module.registerPackets();
        }
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Pre-init start");
            module.preInit(event);
            module.getLogger().debug("Pre-init complete");
        }
    }

    public void onInit(FMLInitializationEvent event) {
        this.currentStage = ModuleStage.INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Init start");
            module.init(event);
            module.getLogger().debug("Init complete");
        }
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.currentStage = ModuleStage.POST_INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Post-init start");
            module.postInit(event);
            module.getLogger().debug("Post-init complete");
        }
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        this.currentStage = ModuleStage.FINISHED;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Load-complete start");
            module.loadComplete(event);
            module.getLogger().debug("Load-complete complete");
        }
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTING;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Server-starting start");
            module.serverStarting(event);
            module.getLogger().debug("Server-starting complete");
        }
    }

    public void onServerStarted(FMLServerStartedEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTED;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Server-started start");
            module.serverStarted(event);
            module.getLogger().debug("Server-started complete");
        }
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.serverStopped(event);
        }
    }

    public void processIMC(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (IGregTechModule module : this.loadedModules) {
                if (module.processIMC(message)) break;
            }
        }
    }

    private void configureModules(Map<String, List<IGregTechModule>> modules) {
        IGregTechModule module;
        Iterator iterator;
        boolean changed;
        GregTechModule annotation;
        HashSet<ResourceLocation> toLoad = new HashSet<ResourceLocation>();
        HashSet<IGregTechModule> modulesToLoad = new HashSet<IGregTechModule>();
        for (IModuleContainer container : this.containers.values()) {
            String containerID = container.getID();
            List<IGregTechModule> containerModules = modules.get(containerID);
            IGregTechModule coreModule = ModuleManager.getCoreModule(containerModules);
            if (coreModule == null) {
                throw new IllegalStateException("Could not find core module for module container " + containerID);
            }
            containerModules.remove(coreModule);
            containerModules.add(0, coreModule);
            Iterator<IGregTechModule> iterator2 = containerModules.iterator();
            while (iterator2.hasNext()) {
                IGregTechModule module2 = iterator2.next();
                if (!this.isModuleEnabled(module2)) {
                    iterator2.remove();
                    this.logger.debug("Module disabled: {}", (Object)module2);
                    continue;
                }
                annotation = module2.getClass().getAnnotation(GregTechModule.class);
                toLoad.add(new ResourceLocation(containerID, annotation.moduleID()));
                modulesToLoad.add(module2);
            }
        }
        do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IGregTechModule)iterator.next();
                Set<ResourceLocation> dependencies = module.getDependencyUids();
                if (!toLoad.containsAll(dependencies)) {
                    iterator.remove();
                    changed = true;
                    GregTechModule annotation2 = module.getClass().getAnnotation(GregTechModule.class);
                    String moduleID = annotation2.moduleID();
                    toLoad.remove(new ResourceLocation(moduleID));
                    this.logger.info("Module {} is missing at least one of module dependencies: {}, skipping loading...", (Object)moduleID, dependencies);
                }
                Set<String> modDependencies = module.getModDependencyIDs();
                for (String modid : modDependencies) {
                    if (Loader.isModLoaded((String)modid)) continue;
                    iterator.remove();
                    changed = true;
                    annotation = module.getClass().getAnnotation(GregTechModule.class);
                    String moduleID = annotation.moduleID();
                    toLoad.remove(new ResourceLocation(moduleID));
                    this.logger.info("Module {} is missing at least one of mod dependencies: {}, skipping loading...", (Object)moduleID, modDependencies);
                }
            }
        } while (changed);
        block5: do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IGregTechModule)iterator.next();
                if (!this.sortedModules.keySet().containsAll(module.getDependencyUids())) continue;
                iterator.remove();
                GregTechModule annotation3 = module.getClass().getAnnotation(GregTechModule.class);
                this.sortedModules.put(new ResourceLocation(annotation3.containerID(), annotation3.moduleID()), module);
                changed = true;
                continue block5;
            }
        } while (changed);
        this.loadedModules.addAll(this.sortedModules.values());
    }

    private static IGregTechModule getCoreModule(List<IGregTechModule> modules) {
        for (IGregTechModule module : modules) {
            GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
            if (!annotation.coreModule()) continue;
            return module;
        }
        return null;
    }

    private static String getContainerID(IGregTechModule module) {
        GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
        return annotation.containerID();
    }

    private Map<String, List<IGregTechModule>> getModules(ASMDataTable table) {
        List<IGregTechModule> instances = this.getInstances(table);
        LinkedHashMap<String, List<IGregTechModule>> modules = new LinkedHashMap<String, List<IGregTechModule>>();
        for (IGregTechModule module : instances) {
            GregTechModule info = module.getClass().getAnnotation(GregTechModule.class);
            modules.computeIfAbsent(info.containerID(), k -> new ArrayList()).add(module);
        }
        return modules;
    }

    private List<IGregTechModule> getInstances(ASMDataTable table) {
        Set dataSet = table.getAll(GregTechModule.class.getCanonicalName());
        ArrayList<IGregTechModule> instances = new ArrayList<IGregTechModule>();
        for (ASMDataTable.ASMData data : dataSet) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                instances.add((IGregTechModule)clazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logger.error("Could not initialize module " + data.getAnnotationInfo().get("moduleID"), (Throwable)e);
            }
        }
        return instances;
    }
}

