/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IFuelInfo;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.impl.ItemFuelInfo;
import gregtech.api.util.GTStringUtils;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import java.util.Collection;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;

public class FuelableInfoProvider
extends CapabilityInfoProvider<IFuelable> {
    public String getID() {
        return "gregtech:fuelable_provider";
    }

    @Override
    @Nonnull
    protected Capability<IFuelable> getCapability() {
        return GregtechCapabilities.CAPABILITY_FUELABLE;
    }

    @Override
    protected boolean allowDisplaying(@Nonnull IFuelable capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected void addProbeInfo(@Nonnull IFuelable capability, IProbeInfo probeInfo, EntityPlayer player, TileEntity tileEntity, IProbeHitData data) {
        Collection<IFuelInfo> fuels = capability.getFuels();
        if (fuels == null || fuels.isEmpty()) {
            probeInfo.text(TextStyleClass.WARNING + "{*gregtech.top.fuel_none*}");
            return;
        }
        for (IFuelInfo fuelInfo : fuels) {
            int fuelRemaining = fuelInfo.getFuelRemaining();
            IProbeInfo horizontal = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            if (fuelInfo instanceof ItemFuelInfo) {
                horizontal.item(((ItemFuelInfo)fuelInfo).getItemStack()).text(TextStyleClass.INFO + "{*" + ((ItemFuelInfo)fuelInfo).getItemStack().func_77977_a() + ".name" + "*}");
            } else {
                horizontal.text(TextStyleClass.INFO + "{*" + fuelInfo.getFuelName() + "*}");
            }
            horizontal.text(TextStyleClass.LABEL + " " + fuelRemaining + " / " + fuelInfo.getFuelCapacity());
            int fuelMinConsumed = fuelInfo.getFuelMinConsumed();
            if (fuelRemaining < fuelMinConsumed) {
                probeInfo.text(TextStyleClass.INFOIMP + "{*gregtech.top.fuel_min_consume*} " + fuelMinConsumed);
                continue;
            }
            probeInfo.text(TextStyleClass.INFO + GTStringUtils.ticksToElapsedTime((int)fuelInfo.getFuelBurnTimeLong()));
        }
    }
}

