/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DebugPipeNetInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gregtech:debug_pipe_net_provider";
    }

    public void addProbeInfo(@Nonnull ProbeMode mode, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull IBlockState blockState, @Nonnull IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ConfigHolder.misc.debug) {
            MetaTileEntity metaTileEntity;
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("MetaTileEntity Id: " + metaTileEntity.metaTileEntityId);
                metaTileEntity.addDebugInfo(list);
                list.forEach(arg_0 -> ((IProbeInfo)probeInfo).text(arg_0));
            }
            if (tileEntity instanceof TileEntityPipeBase) {
                IPipeTile pipeTile = (IPipeTile)tileEntity;
                BlockPipe blockPipe = pipeTile.getPipeBlock();
                Object pipeNet = ((WorldPipeNet)((Object)blockPipe.getWorldPipeNet(world))).getNetFromPos(data.getPos());
                if (pipeNet != null) {
                    probeInfo.text("Net: " + pipeNet.hashCode());
                    probeInfo.text("Node Info: ");
                    StringBuilder builder = new StringBuilder();
                    Node node = ((PipeNet)pipeNet).getAllNodes().get(data.getPos());
                    builder.append("{").append("active: ").append(node.isActive).append(", mark: ").append(node.mark).append(", open: ").append(node.openConnections).append("}");
                    probeInfo.text(builder.toString());
                }
                probeInfo.text("tile open: " + pipeTile.getConnections());
            }
        }
    }
}

