/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.prospector.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.common.terminal.app.prospector.ProspectingTexture;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import gregtech.core.network.packets.PacketProspecting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetProspectingMap
extends Widget {
    private final int chunkRadius;
    private final WidgetOreList oreList;
    private final int mode;
    private final int scanTick;
    private boolean darkMode = false;
    private int chunkIndex = 0;
    @SideOnly(value=Side.CLIENT)
    private ProspectingTexture texture;
    @SideOnly(value=Side.CLIENT)
    private Consumer<PacketProspecting> onPacketReceived;
    Queue<PacketProspecting> packetQueue = new LinkedBlockingQueue<PacketProspecting>();
    public static final int ORE_PROSPECTING_MODE = 0;
    public static final int FLUID_PROSPECTING_MODE = 1;

    public WidgetProspectingMap(int xPosition, int yPosition, int chunkRadius, WidgetOreList widgetOreList, int mode, int scanTick) {
        super(new Position(xPosition, yPosition), new Size(16 * (chunkRadius * 2 - 1), 16 * (chunkRadius * 2 - 1)));
        this.chunkRadius = chunkRadius;
        this.mode = mode;
        this.scanTick = scanTick;
        this.oreList = widgetOreList;
        if (this.oreList != null) {
            this.oreList.onSelected = name -> {
                if (this.texture != null) {
                    this.texture.loadTexture(null, (String)name);
                }
            };
        }
    }

    @SideOnly(value=Side.CLIENT)
    public WidgetProspectingMap setOnPacketReceived(Consumer<PacketProspecting> onPacketReceived) {
        this.onPacketReceived = onPacketReceived;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDarkMode(boolean mode) {
        if (this.darkMode != mode) {
            this.darkMode = mode;
            if (this.texture != null) {
                this.texture.loadTexture(null, this.darkMode);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getDarkMode() {
        return this.darkMode;
    }

    @Override
    public void detectAndSendChanges() {
        block9: {
            int ox;
            int offset;
            EntityPlayer player = this.gui.entityPlayer;
            World world = player.field_70170_p;
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % this.scanTick != 0 || this.chunkIndex >= (this.chunkRadius * 2 - 1) * (this.chunkRadius * 2 - 1)) break block9;
            int cX = (int)player.field_70165_t >> 4;
            int cZ = (int)player.field_70161_v >> 4;
            int r = (int)Math.floor(Math.sqrt(this.chunkIndex));
            r = r / 2 + (r % 2 == 0 ? 0 : 1);
            int side = r == 0 ? 0 : (this.chunkIndex - (2 * r - 1) * (2 * r - 1)) / (2 * r);
            int n = offset = r == 0 ? -1 : (this.chunkIndex - (2 * r - 1) * (2 * r - 1)) % (2 * r);
            int n2 = side == 0 ? -r : (side == 1 ? offset - r + 1 : (ox = side == 2 ? r : -(offset - r + 1)));
            int oz = side == 3 ? r : (side == 0 ? -(offset - r + 1) : (side == 1 ? -r : offset - r + 1));
            Chunk chunk = world.func_72964_e(cX + ox, cZ + oz);
            PacketProspecting packet = new PacketProspecting(cX + ox, cZ + oz, (int)player.field_70165_t, (int)player.field_70161_v, this.mode);
            switch (this.mode) {
                case 0: {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int ySize = chunk.func_76611_b(x, z);
                            for (int y = 1; y < ySize; ++y) {
                                pos.func_181079_c(x, y, z);
                                IBlockState state = chunk.func_177435_g((BlockPos)pos);
                                ItemStack itemBlock = GTUtility.toItem(state);
                                if (!GTUtility.isOre(itemBlock)) continue;
                                boolean added = false;
                                String oreDictString = (String)OreDictUnifier.getOreDictionaryNames(itemBlock).stream().findFirst().get();
                                OrePrefix prefix = OreDictUnifier.getPrefix(itemBlock);
                                Iterator<StoneType> iterator = StoneType.STONE_TYPE_REGISTRY.iterator();
                                while (iterator.hasNext()) {
                                    MaterialStack materialStack;
                                    StoneType type = iterator.next();
                                    if (type.processingPrefix == prefix && type.shouldBeDroppedAsItem) {
                                        packet.addBlock(x, y, z, oreDictString);
                                        added = true;
                                        break;
                                    }
                                    if (type.processingPrefix != prefix || (materialStack = OreDictUnifier.getMaterial(itemBlock)) == null) continue;
                                    packet.addBlock(x, y, z, "ore" + materialStack.material.getLocalizedName());
                                    added = true;
                                    break;
                                }
                                if (added) continue;
                                packet.addBlock(x, y, z, oreDictString);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    BedrockFluidVeinHandler.FluidVeinWorldEntry fStack = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunk.field_76635_g, chunk.field_76647_h);
                    if (fStack == null || fStack.getDefinition() == null) break;
                    packet.addBlock(0, 3, 0, GTUtility.formatNumbers(100.0 * (double)BedrockFluidVeinHandler.getOperationsRemaining(world, chunk.field_76635_g, chunk.field_76647_h) / 100000.0));
                    packet.addBlock(0, 2, 0, "" + BedrockFluidVeinHandler.getFluidYield(world, chunk.field_76635_g, chunk.field_76647_h));
                    packet.addBlock(0, 1, 0, BedrockFluidVeinHandler.getFluidInChunk(world, chunk.field_76635_g, chunk.field_76647_h).getName());
                    break;
                }
            }
            this.writeUpdateInfo(2, packet::writePacketData);
            ++this.chunkIndex;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.texture != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.texture.draw(this.getPosition().x, this.getPosition().y);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        PacketProspecting packet;
        super.readUpdateInfo(id, buffer);
        if (id == 2 && (packet = PacketProspecting.readPacketData(buffer)) != null) {
            if (this.onPacketReceived != null) {
                this.onPacketReceived.accept(packet);
            }
            this.addPacketToQueue(packet);
        }
    }

    @Override
    public void updateScreen() {
        if (this.packetQueue != null) {
            int max = 10;
            while (max-- > 0 && !this.packetQueue.isEmpty()) {
                PacketProspecting packet = this.packetQueue.poll();
                if (this.texture == null) {
                    this.texture = new ProspectingTexture(packet.mode, this.chunkRadius, this.darkMode);
                }
                this.texture.updateTexture(packet);
                if (this.oreList == null) continue;
                this.oreList.addOres(packet.ores, packet.mode);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPacketToQueue(PacketProspecting packet) {
        this.packetQueue.add(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.texture != null) {
            ArrayList<String> tooltips = new ArrayList<String>();
            int cX = (mouseX - this.getPosition().x) / 16;
            int cZ = (mouseY - this.getPosition().y) / 16;
            if (cX >= this.chunkRadius * 2 - 1 || cZ >= this.chunkRadius * 2 - 1) {
                return;
            }
            Gui.func_73734_a((int)(cX * 16 + this.getPosition().x), (int)(cZ * 16 + this.getPosition().y), (int)((cX + 1) * 16 + this.getPosition().x), (int)((cZ + 1) * 16 + this.getPosition().y), (int)new Color(1265396844, true).getRGB());
            if (this.mode == 0) {
                tooltips.add(I18n.func_135052_a((String)"terminal.prospector.ore", (Object[])new Object[0]));
                HashMap<String, Integer> oreInfo = new HashMap<String, Integer>();
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        if (this.texture.map[cX * 16 + i][cZ * 16 + j] == null) continue;
                        this.texture.map[cX * 16 + i][cZ * 16 + j].values().forEach(dict -> {
                            String name = OreDictUnifier.get(dict).func_82833_r();
                            if (this.texture.getSelected().equals("[all]") || this.texture.getSelected().equals(dict)) {
                                oreInfo.put(name, oreInfo.getOrDefault(name, 0) + 1);
                            }
                        });
                    }
                }
                oreInfo.forEach((name, count) -> tooltips.add(name + " --- " + count));
            } else if (this.mode == 1) {
                tooltips.add(I18n.func_135052_a((String)"terminal.prospector.fluid", (Object[])new Object[0]));
                if (this.texture.map[cX][cZ] != null && !this.texture.map[cX][cZ].isEmpty() && (this.texture.getSelected().equals("[all]") || this.texture.getSelected().equals(this.texture.map[cX][cZ].get((byte)1)))) {
                    tooltips.add(I18n.func_135052_a((String)"terminal.prospector.fluid.info", (Object[])new Object[]{FluidRegistry.getFluidStack((String)this.texture.map[cX][cZ].get((byte)1), (int)1).getLocalizedName(), this.texture.map[cX][cZ].get((byte)2), this.texture.map[cX][cZ].get((byte)3)}));
                }
            }
            this.drawHoveringText(ItemStack.field_190927_a, tooltips, 300, mouseX, mouseY);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

