/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.prospector;

import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.util.GTLog;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import gregtech.common.terminal.app.prospector.widget.WidgetProspectingMap;
import gregtech.common.terminal.component.ClickComponent;
import gregtech.common.terminal.component.SearchComponent;
import gregtech.core.network.packets.PacketProspecting;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProspectorApp
extends AbstractApplication
implements SearchComponent.IWidgetSearch<String> {
    WidgetOreList widgetOreList;
    WidgetProspectingMap widgetProspectingMap;
    ColorRectTexture background;
    @SideOnly(value=Side.CLIENT)
    Table<Integer, Integer, PacketProspecting> persist;
    final int mode;

    public ProspectorApp(int mode) {
        super(mode == 0 ? "ore_prospector" : "fluid_prospector");
        this.mode = mode;
    }

    @Override
    public AbstractApplication createAppInstance(TerminalOSWidget os, boolean isClient, NBTTagCompound nbt) {
        ProspectorApp app = new ProspectorApp(this.mode);
        app.isClient = isClient;
        app.nbt = nbt;
        return app;
    }

    @Override
    public AbstractApplication initApp() {
        int chunkRadius = this.getAppTier() + 3;
        int offset = 12;
        this.background = new ColorRectTexture(-1610612736);
        this.addWidget(new ImageWidget(0, 0, 333, 232, this.background));
        if (this.isClient) {
            this.addWidget(new ImageWidget(0, 0, 333, offset, GuiTextures.UI_FRAME_SIDE_UP));
            this.addWidget(new ImageWidget(0, 232 - offset, 333, offset, GuiTextures.UI_FRAME_SIDE_DOWN));
            this.widgetOreList = new WidgetOreList(32 * chunkRadius - 16, offset, 333 - 32 * chunkRadius + 16, 232 - 2 * offset);
            this.addWidget(this.widgetOreList);
        }
        this.widgetProspectingMap = new WidgetProspectingMap(0, offset + (7 - chunkRadius) * 16, chunkRadius, this.widgetOreList, this.mode, 1);
        if (this.isClient) {
            this.persist = Tables.newCustomTable((Map)Maps.newHashMap(), Maps::newHashMap);
            this.widgetProspectingMap.setOnPacketReceived(packet -> {
                PacketProspecting cfr_ignored_0 = (PacketProspecting)this.persist.put((Object)packet.chunkX, (Object)packet.chunkZ, packet);
            });
        }
        this.addWidget(1, this.widgetProspectingMap);
        this.loadLocalConfig(nbt -> {
            this.widgetProspectingMap.setDarkMode(nbt.func_74767_n("dark"));
            this.background.setColor(this.widgetProspectingMap.getDarkMode() ? -1610612736 : -1593835521);
        });
        if (this.isClient) {
            this.loadPacketLocalConfig();
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected void loadPacketLocalConfig() {
        new Thread(() -> {
            int posX = this.gui.entityPlayer.func_180425_c().func_177958_n();
            int posZ = this.gui.entityPlayer.func_180425_c().func_177952_p();
            int playerChunkX = posX >> 4;
            int playerChunkZ = posZ >> 4;
            int chunkRadius = this.getAppTier() + 3 - 1;
            for (int i = playerChunkX - chunkRadius; i <= playerChunkX + chunkRadius; ++i) {
                for (int j = playerChunkZ - chunkRadius; j <= playerChunkZ + chunkRadius; ++j) {
                    PacketProspecting packet;
                    NBTTagCompound nbt = null;
                    try {
                        nbt = CompressedStreamTools.func_74797_a((File)new File(TerminalRegistry.TERMINAL_PATH, String.format("%s/%d/%d_%d.nbt", this.getRegistryName(), this.mode, i, j)));
                    }
                    catch (IOException e) {
                        GTLog.logger.error("error while loading local nbt for {}", (Object)this.getRegistryName(), (Object)e);
                    }
                    if (nbt == null || (packet = PacketProspecting.readPacketData(nbt)) == null) continue;
                    packet.posX = posX;
                    packet.posZ = posZ;
                    this.persist.put((Object)i, (Object)j, (Object)packet);
                    this.widgetProspectingMap.addPacketToQueue(packet);
                }
            }
        }).start();
    }

    @SideOnly(value=Side.CLIENT)
    protected void savePacketLocalConfig() {
        new Thread(() -> {
            File folder = new File(TerminalRegistry.TERMINAL_PATH, String.format("%s/%d", this.getRegistryName(), this.mode));
            if (!folder.exists() && !folder.mkdirs()) {
                return;
            }
            for (Table.Cell cell : this.persist.cellSet()) {
                if (cell.getValue() == null) continue;
                NBTTagCompound nbt = ((PacketProspecting)cell.getValue()).writePacketData();
                try {
                    if (nbt.func_82582_d()) continue;
                    CompressedStreamTools.func_74793_a((NBTTagCompound)nbt, (File)new File(folder, String.format("%d_%d.nbt", cell.getRowKey(), cell.getColumnKey())));
                }
                catch (IOException e) {
                    GTLog.logger.error("error while saving local nbt for {}", (Object)this.getRegistryName(), (Object)e);
                }
            }
        }).start();
    }

    @Override
    public NBTTagCompound closeApp() {
        this.saveLocalConfig(nbt -> nbt.func_74757_a("dark", this.widgetProspectingMap.getDarkMode()));
        if (this.isClient) {
            this.savePacketLocalConfig();
        }
        return super.closeApp();
    }

    @Override
    public int getMaxTier() {
        return 4;
    }

    @Override
    public List<IMenuComponent> getMenuComponents() {
        ClickComponent darkMode = new ClickComponent().setIcon(GuiTextures.ICON_VISIBLE).setHoverText("terminal.prospector.vis_mode").setClickConsumer(cd -> {
            if (cd.isClient) {
                this.widgetProspectingMap.setDarkMode(!this.widgetProspectingMap.getDarkMode());
                this.background.setColor(this.widgetProspectingMap.getDarkMode() ? -1610612736 : -1593835521);
            }
        });
        return Arrays.asList(darkMode, new SearchComponent<String>(this));
    }

    @Override
    public String resultDisplay(String result) {
        if (this.widgetOreList != null) {
            return this.widgetOreList.ores.get(result);
        }
        return "";
    }

    @Override
    public void selectResult(String result) {
        if (this.widgetOreList != null) {
            this.widgetOreList.setSelected(result);
        }
    }

    @Override
    public void search(String word, Consumer<String> find) {
        if (this.widgetOreList != null) {
            word = word.toLowerCase();
            for (Map.Entry<String, String> entry : this.widgetOreList.ores.entrySet()) {
                if (!entry.getKey().toLowerCase().contains(word) && !entry.getValue().toLowerCase().contains(word)) continue;
                find.accept(entry.getKey());
            }
        }
    }
}

