/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.pong;

import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Position;
import gregtech.api.util.TwoDimensionalRayTracer;
import gregtech.common.terminal.app.game.pong.widget.BallWidget;
import gregtech.common.terminal.app.game.pong.widget.PaddleWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.vector.Vector2f;

public class PongApp
extends AbstractApplication {
    private BallWidget ball;
    private int leftScore;
    private int rightScore;
    private List<PaddleWidget> paddles;
    private List<Rectangle> solidObjects;
    private int userInput = -1;
    private int timer = 0;

    public PongApp() {
        super("pong");
    }

    @Override
    public AbstractApplication initApp() {
        if (this.isClient) {
            this.paddles = new ArrayList<PaddleWidget>();
            this.solidObjects = new ArrayList<Rectangle>();
            this.addWidget(new ImageWidget(5, 5, 323, 222, TerminalTheme.COLOR_B_2));
            this.addWidget(new ImageWidget(162, 5, 6, 222, new ColorRectTexture(-1431655766)));
            this.setBall(new BallWidget(165, 115));
            this.addWidget(new SimpleTextWidget(50, 20, "", 0xAAAAAA, () -> String.valueOf(this.getScore(true)), true));
            this.addWidget(new SimpleTextWidget(283, 20, "", 0xAAAAAA, () -> String.valueOf(this.getScore(false)), true));
            this.initPaddles();
        }
        return this;
    }

    @Override
    public boolean canOpenMenuOnEdge() {
        return false;
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }

    public void setBall(BallWidget ball) {
        this.ball = ball;
        this.addWidget(ball);
    }

    public void initPaddles() {
        this.paddles.add(new PaddleWidget(20, 115, 4, 20, paddle -> this.getUserInput()));
        this.paddles.add(new PaddleWidget(313, 115, 4, 20, this::simplePaddleAI));
        this.paddles.forEach(this::addWidget);
        this.solidObjects.add(new Rectangle(0, 0, 333, 10));
        this.solidObjects.add(new Rectangle(0, 222, 333, 10));
    }

    public void score(boolean side) {
        if (side) {
            ++this.leftScore;
            this.ball.theta = 3.1415927410125732;
        } else {
            ++this.rightScore;
            this.ball.theta = 0.0;
        }
        this.ball.theta += Math.random() * 0.2;
        this.ball.setSelfPosition(new Position(165, 115));
    }

    @Override
    public void updateScreenOnFrame() {
        if (this.ball.getSelfPosition().getX() < 10) {
            this.score(false);
        } else if (this.ball.getSelfPosition().getX() > 323) {
            this.score(true);
        } else {
            this.paddles.forEach(paddle -> this.solidObjects.add(new Rectangle(paddle.toSelfRectangleBox())));
            int timeLeft = 1;
            TwoDimensionalRayTracer.TwoDimensionalRayTraceResult result = TwoDimensionalRayTracer.nearestBoxSegmentCollision(new Vector2f((float)this.ball.getSelfPosition().x, (float)this.ball.getSelfPosition().y), new Vector2f((float)(Math.cos(this.ball.theta) * 2.0), (float)(Math.sin(this.ball.theta) * 2.0)), this.solidObjects, new Vector2f(4.0f, 4.0f));
            while (result.time != 1.0f && timeLeft != 0) {
                float angleMod = 0.0f;
                if ((double)result.pos.y < result.collidedWith.getCenterY() - 2.0) {
                    angleMod = (float)((double)angleMod - (double)Math.signum(result.normal.x) * 0.6);
                } else if ((double)result.pos.x > result.collidedWith.getCenterY() + 2.0) {
                    angleMod = (float)((double)angleMod + (double)Math.signum(result.normal.x) * 0.6);
                }
                this.ball.theta = (double)((float)(Math.acos(result.normal.x) * 2.0 - this.ball.theta + Math.PI + (double)angleMod)) % (Math.PI * 2);
                if (this.ball.theta > 1.0707963267948966 && this.ball.theta < 2.0707963267948966) {
                    this.ball.theta = this.ball.theta <= 1.5707963267948966 ? 1.0607963267948965 : 2.0807963267948963;
                }
                if (this.ball.theta > 4.21238898038469 && this.ball.theta < 5.21238898038469) {
                    this.ball.theta = this.ball.theta < 4.71238898038469 ? 4.20238898038469 : 5.2223889803846895;
                }
                timeLeft = (int)((float)timeLeft - result.time * (float)timeLeft);
                result = TwoDimensionalRayTracer.nearestBoxSegmentCollision(new Vector2f((float)this.ball.getSelfPosition().x, (float)this.ball.getSelfPosition().y), new Vector2f((float)(Math.cos(this.ball.theta) * 3.0 * (double)timeLeft), (float)(Math.sin(this.ball.theta) * 3.0 * (double)timeLeft)), this.solidObjects, new Vector2f(4.0f, 4.0f));
                this.ball.addSelfPosition(Math.cos(this.ball.theta) * 2.0 * ((double)result.time + 0.1) * ((double)timeLeft + 0.1), Math.sin(this.ball.theta) * 2.0 * ((double)result.time + 0.1) * ((double)timeLeft + 0.1));
            }
            this.ball.addSelfPosition(Math.cos(this.ball.theta) * 2.0 * (double)timeLeft, Math.sin(this.ball.theta) * 2.0 * (double)timeLeft);
            this.solidObjects.remove(2);
            this.solidObjects.remove(2);
        }
        if (this.ball.getSelfPosition().getY() > 222) {
            this.ball.setSelfPosition(new Position(this.ball.getSelfPosition().getX(), 211));
        } else if (this.ball.getSelfPosition().getY() < 10) {
            this.ball.setSelfPosition(new Position(this.ball.getSelfPosition().getX(), 21));
        }
        ++this.timer;
        this.userInput = Keyboard.isKeyDown((int)200) ^ Keyboard.isKeyDown((int)208) ? (Keyboard.isKeyDown((int)200) ? 1 : 0) : -1;
        super.updateScreenOnFrame();
    }

    public int simplePaddleAI(PaddleWidget paddle) {
        if (this.timer % 3 == 0) {
            return -1;
        }
        if ((this.ball.getSelfPosition().getY() + 2 * paddle.getSelfPosition().getY()) / 3 < paddle.getSelfPosition().getY()) {
            return 1;
        }
        if ((this.ball.getSelfPosition().getY() + 2 * paddle.getSelfPosition().getY()) / 3 > paddle.getSelfPosition().getY()) {
            return 0;
        }
        return -1;
    }

    public int getScore(boolean side) {
        return side ? this.leftScore : this.rightScore;
    }

    public int getUserInput() {
        return this.userInput;
    }
}

