/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.minesweeper;

import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.common.terminal.app.game.minesweeper.widget.MineMapWidget;

public class MinesweeperApp
extends AbstractApplication {
    private MineMapWidget mineField;
    private WidgetGroup textGroup;
    private int timer;
    private int resetCountdown = 100;

    public MinesweeperApp() {
        super("minesweeper");
    }

    @Override
    public AbstractApplication initApp() {
        this.mineField = new MineMapWidget(20, 12, 40);
        this.addWidget(this.mineField);
        this.addWidget(new SimpleTextWidget(55, 10, "", -3355444, this::getFlagsPercentage, true));
        this.textGroup = new WidgetGroup(0, 0, 200, 50);
        this.addWidget(this.textGroup);
        this.setTextStatus();
        return this;
    }

    @Override
    public boolean canOpenMenuOnEdge() {
        return false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.mineField.hasWon() || this.mineField.hasLost()) {
            if (this.mineField.hasWon()) {
                this.mineField.notifyWon();
            }
            --this.resetCountdown;
            this.setTextStatus();
        } else {
            ++this.timer;
        }
        if (this.resetCountdown == 0) {
            this.mineField.resetData();
            this.resetCountdown = 100;
            this.timer = 0;
            this.setTextStatus();
        }
    }

    public String getFlagsPercentage() {
        return this.mineField.flagsPlaced + "/" + this.mineField.mineCount;
    }

    public void setTextStatus() {
        if (this.resetCountdown == 100) {
            this.textGroup.clearAllWidgets();
            this.textGroup.addWidget(new SimpleTextWidget(205, 10, "terminal.minesweeper.time", -3355444, () -> String.valueOf(this.timer / 20), true));
        } else if (this.resetCountdown == 99) {
            this.textGroup.clearAllWidgets();
            if (this.mineField.hasLost()) {
                this.textGroup.addWidget(new SimpleTextWidget(205, 10, "terminal.minesweeper.lose", -3355444, () -> String.valueOf(this.resetCountdown / 20), true));
            } else {
                this.textGroup.addWidget(new SimpleTextWidget(205, 10, "terminal.minesweeper.win.1", -3355444, () -> String.valueOf(this.timer / 20), true));
                this.textGroup.addWidget(new SimpleTextWidget(205, 20, "terminal.minesweeper.win.2", -3355444, () -> String.valueOf(this.resetCountdown / 20), true));
            }
        }
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }
}

