/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.maze;

import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.common.terminal.app.game.maze.widget.EnemyWidget;
import gregtech.common.terminal.app.game.maze.widget.MazeWidget;
import gregtech.common.terminal.app.game.maze.widget.PlayerWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.input.Keyboard;

public class MazeApp
extends AbstractApplication {
    private int gameState = 0;
    private PlayerWidget player;
    private EnemyWidget enemy;
    private MazeWidget maze;
    private int timer = 0;
    private int mazesSolved = 0;
    private float speed = 25.0f;
    private int lastPlayerInput = -2;
    public static int MAZE_SIZE = 9;
    private List<Integer> movementStore;
    private boolean lastPausePress;
    private List<Widget>[] FSM;

    public MazeApp() {
        super("maze");
    }

    @Override
    public AbstractApplication initApp() {
        if (this.isClient) {
            this.movementStore = new ArrayList<Integer>();
            this.FSM = new List[4];
            this.FSM[0] = new LinkedList<Widget>();
            this.FSM[1] = new LinkedList<Widget>();
            this.FSM[2] = new LinkedList<Widget>();
            this.FSM[3] = new LinkedList<Widget>();
            this.setOs(this.os);
            this.addWidget(new ImageWidget(5, 5, 323, 222, TerminalTheme.COLOR_B_2));
            this.addWidget(new LabelWidget(166, 61, "terminal.maze.title", -1).setXCentered(true), 0);
            this.addWidget(new ClickButtonWidget(151, 101, 30, 30, "terminal.maze.play", clickData -> {
                this.setGameState(1);
                this.resetGame();
            }).setShouldClientCallback(true), 0);
            this.setMaze(new MazeWidget());
            this.setPlayer(new PlayerWidget(0, 0, this));
            this.setEnemy(new EnemyWidget(-100, -100, this));
            this.addWidget(new ImageWidget(5, 5, 323, 222, new ColorRectTexture(-16777216)), 2, 3);
            this.addWidget(new ClickButtonWidget(151, 101, 50, 20, "terminal.maze.continue", clickData -> this.setGameState(1)).setShouldClientCallback(true), 2);
            this.addWidget(new LabelWidget(166, 61, "terminal.maze.pause", -1).setXCentered(true), 2);
            this.addWidget(new SimpleTextWidget(166, 76, "", -1, () -> "terminal.maze.death.1", true), 3);
            this.addWidget(new SimpleTextWidget(166, 88, "terminal.maze.death.2", -1, () -> String.valueOf(this.getMazesSolved()), true), 3);
            this.addWidget(new SimpleTextWidget(166, 100, "", -1, () -> "terminal.maze.death.3", true), 3);
            this.addWidget(new ClickButtonWidget(151, 121, 40, 20, "terminal.maze.retry", clickData -> {
                this.setGameState(1);
                this.setMazesSolved(0);
                MAZE_SIZE = 9;
                this.speed = 25.0f;
                this.resetGame();
            }).setShouldClientCallback(true), 3);
        }
        return this;
    }

    public void addWidget(Widget widget, int ... visibleStates) {
        this.addWidget(widget);
        for (int state2 : visibleStates) {
            this.FSM[state2].add(widget);
        }
        widget.setVisible(Arrays.stream(visibleStates).allMatch(state -> state == this.gameState));
    }

    public void setPlayer(PlayerWidget player) {
        this.player = player;
        this.addWidget(player, 1, 2, 3);
    }

    public void setMaze(MazeWidget maze) {
        this.maze = maze;
        this.addWidget(maze, 1, 2, 3);
    }

    public void setEnemy(EnemyWidget enemy) {
        this.enemy = enemy;
        this.addWidget(enemy, 1, 2, 3);
    }

    @Override
    public boolean canOpenMenuOnEdge() {
        return this.gameState != 1;
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        int lastState = this.gameState;
        if (this.gameState == 1) {
            if (Keyboard.isKeyDown((int)25)) {
                this.gameState = 2;
                this.lastPausePress = true;
            }
            if (Keyboard.isKeyDown((int)203) ^ Keyboard.isKeyDown((int)205)) {
                if (Keyboard.isKeyDown((int)203)) {
                    this.attemptMovePlayer(0);
                } else {
                    this.attemptMovePlayer(1);
                }
            }
            if (Keyboard.isKeyDown((int)200) ^ Keyboard.isKeyDown((int)208)) {
                if (Keyboard.isKeyDown((int)200)) {
                    this.attemptMovePlayer(2);
                } else {
                    this.attemptMovePlayer(3);
                }
            }
            ++this.timer;
            if (this.enemy.posX < 0 && (float)this.timer % (this.speed * (float)MAZE_SIZE - 1.0f) < 1.0f) {
                this.enemy.setGridPosition(0, 0);
            } else if ((float)this.timer % this.speed < 1.0f) {
                this.moveEnemy();
            }
            if (this.enemy.posX == this.player.posX && this.enemy.posY == this.player.posY) {
                this.gameState = 3;
            }
        }
        if (this.gameState == 2) {
            if (!Keyboard.isKeyDown((int)25)) {
                this.lastPausePress = false;
            }
            if (Keyboard.isKeyDown((int)25) && !this.lastPausePress) {
                this.gameState = 1;
            }
        }
        if (this.gameState != lastState) {
            this.FSM[lastState].forEach(widget -> widget.setVisible(false));
            this.FSM[this.gameState].forEach(widget -> widget.setVisible(true));
        }
    }

    public int getGameState() {
        return this.gameState;
    }

    public void setGameState(int gameState) {
        if (gameState != this.gameState) {
            this.FSM[this.gameState].forEach(widget -> widget.setVisible(false));
            this.FSM[gameState].forEach(widget -> widget.setVisible(true));
        }
        this.gameState = gameState;
    }

    public int getRenderX(int posX) {
        return this.maze.getSelfPosition().x + posX * 10;
    }

    public int getRenderY(int posY) {
        return this.maze.getSelfPosition().y + posY * 10;
    }

    public int getTimer() {
        return this.timer;
    }

    private void attemptMovePlayer(int direction) {
        if (this.timer < this.lastPlayerInput + 2) {
            return;
        }
        this.lastPlayerInput = this.timer;
        if (this.player.posX == MAZE_SIZE - 1 && this.player.posY == MAZE_SIZE - 1 && direction == 3) {
            ++this.mazesSolved;
            this.speed = (float)((double)this.speed * 0.95);
            if (this.mazesSolved % 4 == 0) {
                MAZE_SIZE += 2;
                this.speed = (float)((double)this.speed * 1.07);
            }
            this.resetGame();
            return;
        }
        if (direction == 0 && !this.maze.isThereWallAt(this.player.posX, this.player.posY, false)) {
            this.player.move(-1, 0);
            if (this.movementStore.size() > 0 && this.movementStore.get(this.movementStore.size() - 1) == 1) {
                this.movementStore.remove(this.movementStore.size() - 1);
            } else {
                this.movementStore.add(direction);
            }
        } else if (direction == 1 && !this.maze.isThereWallAt(this.player.posX + 1, this.player.posY, false)) {
            this.player.move(1, 0);
            if (this.movementStore.size() > 0 && this.movementStore.get(this.movementStore.size() - 1) == 0) {
                this.movementStore.remove(this.movementStore.size() - 1);
            } else {
                this.movementStore.add(direction);
            }
        } else if (direction == 2 && !this.maze.isThereWallAt(this.player.posX, this.player.posY, true)) {
            this.player.move(0, -1);
            if (this.movementStore.size() > 0 && this.movementStore.get(this.movementStore.size() - 1) == 3) {
                this.movementStore.remove(this.movementStore.size() - 1);
            } else {
                this.movementStore.add(direction);
            }
        } else if (direction == 3 && !this.maze.isThereWallAt(this.player.posX, this.player.posY + 1, true)) {
            this.player.move(0, 1);
            if (this.movementStore.size() > 0 && this.movementStore.get(this.movementStore.size() - 1) == 2) {
                this.movementStore.remove(this.movementStore.size() - 1);
            } else {
                this.movementStore.add(direction);
            }
        }
    }

    private void moveEnemy() {
        if (this.enemy.posX < 0 || this.movementStore.isEmpty()) {
            return;
        }
        int direction = this.movementStore.get(0);
        if (direction == 0) {
            this.enemy.move(-1, 0);
        } else if (direction == 1) {
            this.enemy.move(1, 0);
        } else if (direction == 2) {
            this.enemy.move(0, -1);
        } else if (direction == 3) {
            this.enemy.move(0, 1);
        }
        this.movementStore.remove(0);
    }

    private void resetGame() {
        this.player.setGridPosition(0, 0);
        this.maze.recalculateSize();
        this.maze.initMaze();
        this.movementStore.clear();
        this.timer = 0;
        this.lastPlayerInput = -5;
        this.enemy.setGridPosition(-100, -100);
    }

    public int getMazesSolved() {
        return this.mazesSolved;
    }

    public void setMazesSolved(int mazesSolved) {
        this.mazesSolved = mazesSolved;
    }
}

