/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CraftingStationInputWidgetGroup;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TabGroup;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.gui.widgets.tab.ItemTabInfo;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.storage.ICraftingStorage;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.craftingstation.CraftingSlotWidget;
import gregtech.common.gui.widget.craftingstation.ItemListGridWidget;
import gregtech.common.gui.widget.craftingstation.MemorizedRecipeWidget;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.inventory.handlers.ToolItemStackHandler;
import gregtech.common.inventory.itemsource.ItemSources;
import gregtech.common.inventory.itemsource.sources.InventoryItemSource;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityWorkbench
extends MetaTileEntity
implements ICraftingStorage {
    private final ItemStackHandler internalInventory = new ItemStackHandler(18);
    private final ItemStackHandler craftingGrid = new SingleItemStackHandler(9);
    private final ItemStackHandler toolInventory = new ToolItemStackHandler(9);
    private final CraftingRecipeMemory recipeMemory = new CraftingRecipeMemory(9);
    private CraftingRecipeLogic recipeLogic = null;
    private int itemsCrafted = 0;
    private final ArrayList<EntityPlayer> listeners = new ArrayList();

    public MetaTileEntityWorkbench(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    public static AbstractWidgetGroup createWorkbenchTab(CraftingRecipeLogic craftingRecipeLogic, ItemStackHandler craftingGrid, CraftingRecipeMemory recipeMemory, ItemStackHandler toolInventory, ItemStackHandler internalInventory) {
        int j;
        int i;
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.addWidget(new ImageWidget(75, 30, 26, 26, GuiTextures.SLOT));
        widgetGroup.addWidget(new CraftingSlotWidget(craftingRecipeLogic, 0, 79, 35));
        widgetGroup.addWidget(new CraftingStationInputWidgetGroup(4, 7, craftingGrid, craftingRecipeLogic));
        Supplier<String> textSupplier = () -> Integer.toString(craftingRecipeLogic.getItemsCraftedAmount());
        widgetGroup.addWidget(new SimpleTextWidget(88, 63, "", textSupplier));
        Consumer<Widget.ClickData> clearAction = clickData -> craftingRecipeLogic.clearCraftingGrid();
        widgetGroup.addWidget(new ClickButtonWidget(65, 16, 8, 8, "", clearAction).setButtonTexture(GuiTextures.BUTTON_CLEAR_GRID));
        widgetGroup.addWidget(new ImageWidget(114, 16, 54, 54, TextureArea.fullImage("textures/gui/base/darkened_slot.png")));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                widgetGroup.addWidget(new MemorizedRecipeWidget(recipeMemory, j + i * 3, (IItemHandlerModifiable)craftingGrid, 114 + j * 18, 16 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            widgetGroup.addWidget(new SlotWidget((IItemHandlerModifiable)toolInventory, i, 7 + i * 18, 75).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.TOOL_SLOT_OVERLAY));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                widgetGroup.addWidget(new SlotWidget((IItemHandlerModifiable)internalInventory, j + i * 9, 7 + j * 18, 98 + i * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        return widgetGroup;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityWorkbench(this.metaTileEntityId);
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.CRAFTING_TABLE.getParticleSprite(), (Object)this.getDefaultPaintingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        int paintingColor = this.getPaintingColorForRendering();
        pipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(paintingColor)));
        Textures.CRAFTING_TABLE.renderOriented(renderState, translation, pipeline, this.getFrontFacing());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("CraftingGridInventory", (NBTBase)this.craftingGrid.serializeNBT());
        data.func_74782_a("ToolInventory", (NBTBase)this.toolInventory.serializeNBT());
        data.func_74782_a("InternalInventory", (NBTBase)this.internalInventory.serializeNBT());
        data.func_74768_a("ItemsCrafted", this.recipeLogic == null ? this.itemsCrafted : this.recipeLogic.getItemsCraftedAmount());
        data.func_74782_a("RecipeMemory", (NBTBase)this.recipeMemory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.deserializeNBT(data.func_74775_l("CraftingGridInventory"));
        this.toolInventory.deserializeNBT(data.func_74775_l("ToolInventory"));
        this.internalInventory.deserializeNBT(data.func_74775_l("InternalInventory"));
        this.itemsCrafted = data.func_74762_e("ItemsCrafted");
        this.recipeMemory.deserializeNBT(data.func_74775_l("RecipeMemory"));
    }

    private void createCraftingRecipeLogic(EntityPlayer entityPlayer) {
        if (!this.getWorld().field_72995_K) {
            if (this.recipeLogic == null) {
                this.recipeLogic = new CraftingRecipeLogic(this);
                this.recipeLogic.setItemsCraftedAmount(this.itemsCrafted);
                ItemSources itemSources = this.recipeLogic.getItemSourceList();
                itemSources.addItemHandler(new InventoryItemSource(this.getWorld(), (IItemHandler)this.toolInventory, -2));
                itemSources.addItemHandler(new InventoryItemSource(this.getWorld(), (IItemHandler)this.internalInventory, -1));
                this.recipeLogic.checkNeighbourInventories(this.getPos());
            }
            this.listeners.add(entityPlayer);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.recipeLogic != null) {
            this.getRecipeLogic().update();
        }
    }

    private CraftingRecipeLogic getRecipeLogic() {
        Preconditions.checkState((this.getWorld() != null ? 1 : 0) != 0, (Object)"getRecipeResolver called too early");
        return this.recipeLogic;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.internalInventory);
        MetaTileEntityWorkbench.clearInventory(itemBuffer, (IItemHandlerModifiable)this.toolInventory);
    }

    private AbstractWidgetGroup createItemListTab() {
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.addWidget(new LabelWidget(5, 20, "gregtech.machine.workbench.storage_note_1", new Object[0]));
        widgetGroup.addWidget(new LabelWidget(5, 30, "gregtech.machine.workbench.storage_note_2", new Object[0]));
        CraftingRecipeLogic recipeResolver = this.getRecipeLogic();
        ItemSources itemList = recipeResolver == null ? null : recipeResolver.getItemSourceList();
        widgetGroup.addWidget(new ItemListGridWidget(11, 45, 8, 5, itemList));
        return widgetGroup;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        this.createCraftingRecipeLogic(entityPlayer);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 221).bindPlayerInventory(entityPlayer.field_71071_by, 138);
        builder.label(5, 5, this.getMetaFullName());
        TabGroup<AbstractWidgetGroup> tabGroup = new TabGroup<AbstractWidgetGroup>(TabGroup.TabLocation.HORIZONTAL_TOP_LEFT, Position.ORIGIN);
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.workbench", new ItemStack(Blocks.field_150462_ai)), MetaTileEntityWorkbench.createWorkbenchTab(this.recipeLogic, this.craftingGrid, this.recipeMemory, this.toolInventory, this.internalInventory));
        tabGroup.addTab(new ItemTabInfo("gregtech.machine.workbench.tab.item_list", new ItemStack((Block)Blocks.field_150486_ae)), this.createItemListTab());
        builder.widget(tabGroup);
        builder.bindCloseListener(() -> this.discardRecipeResolver(entityPlayer));
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.workbench.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.workbench.tooltip2", (Object[])new Object[0]));
    }

    public void discardRecipeResolver(EntityPlayer entityPlayer) {
        this.listeners.remove(entityPlayer);
        if (this.listeners.isEmpty()) {
            if (!this.getWorld().field_72995_K && this.recipeLogic != null) {
                this.itemsCrafted = this.recipeLogic.getItemsCraftedAmount();
                this.markDirty();
            }
            this.recipeLogic = null;
        }
    }

    @Override
    public ItemStackHandler getCraftingGrid() {
        return this.craftingGrid;
    }

    public ItemStackHandler getToolInventory() {
        return this.toolInventory;
    }

    @Override
    public CraftingRecipeMemory getRecipeMemory() {
        return this.recipeMemory;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canRenderMachineGrid() {
        return false;
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }
}

