/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.worldgen.LootTableHelper;
import gregtech.loaders.recipe.CraftingComponent;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityLockedSafe
extends MetaTileEntity
implements IFastRenderMetaTileEntity {
    private static final int MAX_UNLOCK_PROGRESS = 100;
    private static CraftingComponent.Component[] ALLOWED_COMPONENTS;
    private static final IndexedCuboid6 COLLISION_BOX;
    private int unlockProgress = -1;
    private int unlockComponentTier = 1;
    private boolean isSafeUnlocked = false;
    private long unlockComponentsSeed = 0L;
    private final ItemStackHandler unlockComponents = new ItemStackHandler(2);
    private final ItemStackHandler unlockInventory = new ItemStackHandler(2){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int maxStackSize = MetaTileEntityLockedSafe.this.canPutUnlockItemInSlot(slot, stack);
            if (maxStackSize == 0) {
                return stack;
            }
            int maxAmount = Math.min(maxStackSize, stack.func_190916_E());
            int remainder = stack.func_190916_E() - maxAmount;
            stack = stack.func_77946_l();
            stack.func_190920_e(maxAmount);
            int addAmount = super.insertItem(slot, stack, simulate).func_190916_E();
            int totalAmount = remainder + addAmount;
            return totalAmount == 0 ? ItemStack.field_190927_a : GTUtility.copyAmount(totalAmount, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MetaTileEntityLockedSafe.this.recheckUnlockItemsAndUnlock();
        }
    };
    private final ItemStackHandler safeLootInventory = new ItemStackHandler(27);
    private float doorAngle = 0.0f;
    private float prevDoorAngle = 0.0f;

    public MetaTileEntityLockedSafe(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        if (this.isSafeUnlocked()) {
            MetaTileEntityLockedSafe.clearInventory(itemBuffer, (IItemHandlerModifiable)this.safeLootInventory);
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLockedSafe(this.metaTileEntityId);
    }

    @Override
    public void update() {
        super.update();
        this.updateOpenVisualAnimation();
        this.updateOpenProgress();
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        this.generateUnlockComponents();
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public void addCollisionBoundingBox(List<IndexedCuboid6> collisionList) {
        collisionList.add(COLLISION_BOX);
    }

    @Override
    public boolean shouldDropWhenDestroyed() {
        return false;
    }

    @Override
    public float getBlockHardness() {
        return this.isSafeUnlocked() ? 6.0f : -1.0f;
    }

    @Override
    public float getBlockResistance() {
        return 6000000.0f;
    }

    private void generateUnlockComponents() {
        if (!this.getWorld().field_72995_K && this.unlockComponentsSeed == 0L) {
            this.setUnlockComponentsSeed(new Random().nextLong());
        }
    }

    private void updateDisplayUnlockComponents() {
        GTRecipeInput[] unlockComponents = this.getUnlockComponents();
        for (int i = 0; i < Math.min(this.unlockComponents.getSlots(), unlockComponents.length); ++i) {
            if (unlockComponents[i].isOreDict()) {
                this.unlockComponents.setStackInSlot(i, (ItemStack)OreDictionary.getOres((String)OreDictionary.getOreName((int)unlockComponents[i].getOreDict())).get(0));
                continue;
            }
            this.unlockComponents.setStackInSlot(i, unlockComponents[i].getInputStacks()[0]);
        }
    }

    private GTRecipeInput[] getUnlockComponents() {
        if (ALLOWED_COMPONENTS == null) {
            ALLOWED_COMPONENTS = new CraftingComponent.Component[]{CraftingComponent.PUMP, CraftingComponent.CONVEYOR, CraftingComponent.EMITTER, CraftingComponent.SENSOR};
        }
        Random random = new Random(this.unlockComponentsSeed);
        return new GTRecipeInput[]{GTRecipeOreInput.getOrCreate(CraftingComponent.CIRCUIT.getIngredient(this.unlockComponentTier).toString()), GTRecipeItemInput.getOrCreate((ItemStack)ALLOWED_COMPONENTS[random.nextInt(ALLOWED_COMPONENTS.length)].getIngredient(this.unlockComponentTier))};
    }

    private void recheckUnlockItemsAndUnlock() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K && !this.isSafeUnlocked() && this.checkUnlockedItems() && this.unlockProgress == -1) {
            ++this.unlockProgress;
            this.markDirty();
        }
    }

    private int canPutUnlockItemInSlot(int slot, ItemStack itemStack) {
        GTRecipeInput[] unlockComponents;
        if (itemStack.func_190926_b()) {
            return 0;
        }
        boolean isRequiredItem = false;
        int amountRequired = 0;
        for (GTRecipeInput stack : unlockComponents = this.getUnlockComponents()) {
            if (stack == null || !stack.acceptsStack(itemStack)) continue;
            amountRequired = stack.getAmount();
            isRequiredItem = true;
            break;
        }
        if (!isRequiredItem) {
            return 0;
        }
        for (int i = 0; i < this.unlockInventory.getSlots(); ++i) {
            ItemStack componentStack = this.unlockInventory.getStackInSlot(i);
            if (componentStack.func_190926_b() || !componentStack.func_77969_a(itemStack)) continue;
            return slot == i ? amountRequired - componentStack.func_190916_E() : 0;
        }
        return amountRequired;
    }

    private boolean checkUnlockedItems() {
        GTRecipeInput[] unlockComponents;
        for (GTRecipeInput stack : unlockComponents = this.getUnlockComponents()) {
            if (stack == null) continue;
            int itemLeftToCheck = stack.getAmount();
            for (int i = 0; i < this.unlockInventory.getSlots(); ++i) {
                ItemStack otherStack = this.unlockInventory.getStackInSlot(i);
                if (otherStack.func_190926_b() || stack.acceptsStack(otherStack)) continue;
                itemLeftToCheck -= otherStack.func_190916_E();
            }
            if (itemLeftToCheck <= 0) continue;
            return false;
        }
        return true;
    }

    private void updateOpenProgress() {
        if (!this.getWorld().field_72995_K && this.unlockProgress >= 0 && this.unlockProgress < 100) {
            ++this.unlockProgress;
            if (this.unlockProgress >= 100) {
                this.generateChestContents();
                this.setSafeUnlocked(true);
            }
        }
    }

    private void generateChestContents() {
        ResourceLocation lootTableLocation = new ResourceLocation("gregtech", "chests/abandoned_safe_" + this.unlockComponentTier);
        WorldServer worldServer = (WorldServer)this.getWorld();
        LootTable lootTable = worldServer.func_184146_ak().func_186521_a(lootTableLocation);
        LootContext lootContext = new LootContext.Builder(worldServer).func_186471_a();
        Random random = new Random();
        List loots = lootTable.func_186462_a(random, lootContext);
        LootTableHelper.fillInventory((IItemHandlerModifiable)this.safeLootInventory, random, loots);
    }

    private void updateOpenVisualAnimation() {
        this.prevDoorAngle = this.doorAngle;
        if (!this.isSafeUnlocked && this.doorAngle > 0.0f || this.isSafeUnlocked && this.doorAngle < 1.0f) {
            this.doorAngle = this.isSafeUnlocked ? (this.doorAngle += 0.1f) : (this.doorAngle -= 0.1f);
            if (this.doorAngle > 1.0f) {
                this.doorAngle = 1.0f;
            } else if (this.doorAngle < 0.0f) {
                this.doorAngle = 0.0f;
            }
        }
    }

    public boolean isSafeUnlocked() {
        return this.isSafeUnlocked;
    }

    public void setSafeUnlocked(boolean safeUnlocked) {
        this.isSafeUnlocked = safeUnlocked;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.writeCustomData(8, buf -> buf.writeBoolean(safeUnlocked));
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    protected void setUnlockComponentsSeed(long unlockComponentsSeed) {
        this.unlockComponentsSeed = unlockComponentsSeed;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.updateDisplayUnlockComponents();
            this.writeCustomData(9, buf -> buf.func_179254_b(unlockComponentsSeed));
            this.markDirty();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.unlockComponentTier);
        buf.writeBoolean(this.isSafeUnlocked);
        buf.writeFloat(this.doorAngle);
        buf.func_179254_b(this.unlockComponentsSeed);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.unlockComponentTier = buf.func_150792_a();
        this.isSafeUnlocked = buf.readBoolean();
        this.prevDoorAngle = this.doorAngle = buf.readFloat();
        this.unlockComponentsSeed = buf.func_179260_f();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 8) {
            this.isSafeUnlocked = buf.readBoolean();
        } else if (dataId == 9) {
            this.unlockComponentsSeed = buf.func_179260_f();
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("ComponentTier", 99)) {
            this.unlockComponentTier = itemStack.func_74762_e("ComponentTier");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        data.func_74768_a("UnlockProgress", this.unlockProgress);
        data.func_74768_a("ComponentTier", this.unlockComponentTier);
        data.func_74757_a("Unlocked", this.isSafeUnlocked);
        data.func_74772_a("UnlockComponentsSeed", this.unlockComponentsSeed);
        data.func_74782_a("UnlockInventory", (NBTBase)this.unlockInventory.serializeNBT());
        data.func_74782_a("LootInventory", (NBTBase)this.safeLootInventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.unlockProgress = data.func_74762_e("UnlockProgress");
        this.unlockComponentTier = data.func_74762_e("ComponentTier");
        this.isSafeUnlocked = data.func_74767_n("Unlocked");
        this.unlockComponentsSeed = data.func_74763_f("UnlockComponentsSeed");
        this.unlockInventory.deserializeNBT(data.func_74775_l("UnlockInventory"));
        this.safeLootInventory.deserializeNBT(data.func_74775_l("LootInventory"));
        this.updateDisplayUnlockComponents();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
    }

    @Override
    public void renderMetaTileEntityFast(CCRenderState renderState, Matrix4 translation, float partialTicks) {
        ColourMultiplier colourMultiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(GTValues.VC[this.unlockComponentTier]));
        float angle = this.prevDoorAngle + (this.doorAngle - this.prevDoorAngle) * partialTicks;
        angle = 1.0f - (1.0f - angle) * (1.0f - angle) * (1.0f - angle);
        float resultDoorAngle = angle * 120.0f;
        Textures.SAFE.render(renderState, translation, new IVertexOperation[]{colourMultiplier}, this.getFrontFacing(), resultDoorAngle);
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.SAFE.getParticleTexture(), (Object)GTValues.VC[this.unlockComponentTier]);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos().func_177982_a(-1, 0, -1), this.getPos().func_177982_a(2, 1, 2));
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        DoubleSupplier supplier = () -> 0.2 + (double)this.unlockProgress / 100.0 * 0.8;
        ModularUI.Builder builder = ModularUI.defaultBuilder().widget(new ProgressWidget(supplier, 5, 5, 166, 74, GuiTextures.PROGRESS_BAR_UNLOCK, ProgressWidget.MoveType.VERTICAL_INVERTED)).bindPlayerInventory(entityPlayer.field_71071_by);
        ServerWidgetGroup lockedGroup = new ServerWidgetGroup(() -> !this.isSafeUnlocked && this.unlockProgress < 0);
        lockedGroup.addWidget(new LabelWidget(5, 20, "gregtech.machine.locked_safe.malfunctioning", new Object[0]));
        lockedGroup.addWidget(new LabelWidget(5, 30, "gregtech.machine.locked_safe.requirements", new Object[0]));
        lockedGroup.addWidget(new SlotWidget((IItemHandler)this.unlockInventory, 0, 70, 40, false, true).setBackgroundTexture(GuiTextures.SLOT));
        lockedGroup.addWidget(new SlotWidget((IItemHandler)this.unlockInventory, 1, 88, 40, false, true).setBackgroundTexture(GuiTextures.SLOT));
        lockedGroup.addWidget(new SlotWidget((IItemHandler)this.unlockComponents, 0, 70, 58, false, false));
        lockedGroup.addWidget(new SlotWidget((IItemHandler)this.unlockComponents, 1, 88, 58, false, false));
        ServerWidgetGroup unlockedGroup = new ServerWidgetGroup(() -> this.isSafeUnlocked);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                unlockedGroup.addWidget(new SlotWidget((IItemHandler)this.safeLootInventory, col + row * 9, 8 + col * 18, 15 + row * 18, true, false));
            }
        }
        return builder.widget(unlockedGroup).widget(lockedGroup).build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canRenderMachineGrid() {
        return false;
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    static {
        COLLISION_BOX = new IndexedCuboid6(null, new Cuboid6(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125));
    }
}

