/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.ThermalFluidHandlerItemStack;
import gregtech.api.fluids.MaterialFluid;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.fluids.fluidType.FluidTypes;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityDrum
extends MetaTileEntity {
    private final int tankSize;
    private final Material material;
    private FilteredFluidHandler fluidTank;
    private boolean isAutoOutput = false;

    public MetaTileEntityDrum(ResourceLocation metaTileEntityId, Material material, int tankSize) {
        super(metaTileEntityId);
        this.tankSize = tankSize;
        this.material = material;
        if (!ModHandler.isMaterialWood(material) && !this.material.hasProperty(PropertyKey.FLUID_PIPE)) {
            throw new IllegalArgumentException(String.format("Material %s requires FluidPipePropety for Drums", material));
        }
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDrum(this.metaTileEntityId, this.material, this.tankSize);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public int getActualComparatorValue() {
        FilteredFluidHandler fluidTank = this.fluidTank;
        int fluidAmount = fluidTank.getFluidAmount();
        int maxCapacity = fluidTank.getCapacity();
        float f = (float)fluidAmount / ((float)maxCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (fluidAmount > 0 ? 1 : 0);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public String getHarvestTool() {
        return ModHandler.isMaterialWood(this.material) ? "axe" : "wrench";
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.fluidTank = new FilteredFluidHandler(this.tankSize).setFillPredicate(stack -> {
            if (stack == null || stack.getFluid() == null) {
                return false;
            }
            Fluid fluid = stack.getFluid();
            if (ModHandler.isMaterialWood(this.material)) {
                boolean meetsGTRequirements = true;
                if (fluid instanceof MaterialFluid) {
                    FluidType fluidType = ((MaterialFluid)fluid).getFluidType();
                    meetsGTRequirements = fluidType != FluidTypes.ACID && fluidType != FluidTypes.PLASMA;
                }
                return fluid.getTemperature() <= 340 && !fluid.isGaseous() && meetsGTRequirements;
            }
            FluidPipeProperties pipeProperties = this.material.getProperty(PropertyKey.FLUID_PIPE);
            if (fluid.getTemperature() > pipeProperties.getMaxFluidTemperature()) {
                return false;
            }
            if (fluid.getTemperature() < 120 && !pipeProperties.isCryoProof()) {
                return false;
            }
            if (fluid.isGaseous() && !pipeProperties.isGasProof()) {
                return false;
            }
            if (fluid instanceof MaterialFluid) {
                FluidType fluidType = ((MaterialFluid)fluid).getFluidType();
                if (fluidType == FluidTypes.ACID && !pipeProperties.isAcidProof()) {
                    return false;
                }
                if (fluidType == FluidTypes.PLASMA && !pipeProperties.isPlasmaProof()) {
                    return false;
                }
            }
            return true;
        });
        this.fluidInventory = this.fluidTank;
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid"));
            this.fluidTank.setFluid(fluidStack);
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            itemStack.func_74782_a("Fluid", (NBTBase)tagCompound);
        }
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        if (ModHandler.isMaterialWood(this.material) || this.material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return new ThermalFluidHandlerItemStack(itemStack, this.tankSize, 340, false, false, false, false);
        }
        FluidPipeProperties pipeProperties = this.material.getProperty(PropertyKey.FLUID_PIPE);
        return new ThermalFluidHandlerItemStack(itemStack, this.tankSize, pipeProperties.getMaxFluidTemperature(), pipeProperties.isGasProof(), pipeProperties.isAcidProof(), pipeProperties.isCryoProof(), pipeProperties.isPlasmaProof());
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        FluidStack fluidStack = this.fluidTank.getFluid();
        buf.writeBoolean(fluidStack != null);
        if (fluidStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(tagCompound);
            buf.func_150786_a(tagCompound);
        }
        buf.writeBoolean(this.isAutoOutput);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        FluidStack fluidStack = null;
        if (buf.readBoolean()) {
            try {
                NBTTagCompound tagCompound = buf.func_150793_b();
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fluidTank.setFluid(fluidStack);
        this.isAutoOutput = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 560) {
            this.isAutoOutput = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.isAutoOutput && this.getOffsetTimer() % 5L == 0L) {
            this.pushFluidsIntoNearbyHandlers(EnumFacing.DOWN);
        }
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (playerIn.func_184586_b(hand).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return this.getWorld().field_72995_K || !playerIn.func_70093_af() && FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)this.fluidTank);
        }
        return false;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getWorld().field_72995_K) {
                this.scheduleRenderUpdate();
                return true;
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.drum." + (this.isAutoOutput ? "disable" : "enable") + "_output", new Object[0]));
            this.toggleOutput();
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, wrenchSide, hitResult);
    }

    private void toggleOutput() {
        boolean bl = this.isAutoOutput = !this.isAutoOutput;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(560, buf -> buf.writeBoolean(this.isAutoOutput));
            this.markDirty();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        if (ModHandler.isMaterialWood(this.material)) {
            return Pair.of((Object)Textures.WOODEN_DRUM.getParticleTexture(), (Object)this.getPaintingColorForRendering());
        }
        int color = ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.getMaterialRGB()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
        color = GTUtility.convertOpaqueRGBA_CLtoRGB(color);
        return Pair.of((Object)Textures.DRUM.getParticleTexture(), (Object)color);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        if (ModHandler.isMaterialWood(this.material)) {
            ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
            Textures.WOODEN_DRUM.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier), this.getFrontFacing());
        } else {
            ColourMultiplier multiplier = new ColourMultiplier(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.getMaterialRGB()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
            Textures.DRUM.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier), this.getFrontFacing());
            Textures.DRUM_OVERLAY.render(renderState, translation, pipeline);
        }
        if (this.isAutoOutput) {
            Textures.STEAM_VENT_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.tankSize}));
        if (TooltipHelper.isShiftDown()) {
            if (ModHandler.isMaterialWood(this.material)) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.max_temperature", (Object[])new Object[]{340}));
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.not_gas_proof", (Object[])new Object[0]));
            } else {
                FluidPipeProperties pipeProperties = this.material.getProperty(PropertyKey.FLUID_PIPE);
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.max_temperature", (Object[])new Object[]{pipeProperties.getMaxFluidTemperature()}));
                if (pipeProperties.isGasProof()) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.gas_proof", (Object[])new Object[0]));
                }
                if (pipeProperties.isAcidProof()) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.acid_proof", (Object[])new Object[0]));
                }
                if (pipeProperties.isCryoProof()) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.cryo_proof", (Object[])new Object[0]));
                }
                if (pipeProperties.isPlasmaProof()) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.plasma_proof", (Object[])new Object[0]));
                }
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.tool_fluid_hold_shift", (Object[])new Object[0]));
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Fluid", 10)) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
            if (fluidStack == null) {
                return;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_tank.fluid", (Object[])new Object[]{fluidStack.amount, I18n.func_135052_a((String)fluidStack.getUnlocalizedName(), (Object[])new Object[0])}));
        }
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("FluidInventory", (NBTBase)((FluidTank)this.fluidInventory).writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AutoOutput", this.isAutoOutput);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        ((FluidTank)this.fluidInventory).readFromNBT(data.func_74775_l("FluidInventory"));
        this.isAutoOutput = data.func_74767_n("AutoOutput");
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }
}

