/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.IMachineHatchMultiblock;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityMachineHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IItemHandlerModifiable> {
    private final IItemHandlerModifiable machineHandler = new LimitedImportHandler();

    public MetaTileEntityMachineHatch(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier, false);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMachineHatch(this.metaTileEntityId, this.getTier());
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return MultiblockAbility.MACHINE_HATCH;
    }

    @Override
    public void registerAbilities(List<IItemHandlerModifiable> abilityList) {
        abilityList.add(this.machineHandler);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return this.machineHandler;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 130).label(10, 5, this.getMetaFullName());
        builder.widget(new SlotWidget((IItemHandler)this.machineHandler, 0, 81, 18, true, true).setBackgroundTexture(GuiTextures.SLOT));
        return builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 48).build(this.getHolder(), entityPlayer);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    private int getMachineLimit() {
        if (this.getController() instanceof IMachineHatchMultiblock) {
            return ((IMachineHatchMultiblock)((Object)this.getController())).getMachineLimit();
        }
        return 64;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.machine_hatch.processing_array", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private class LimitedImportHandler
    extends NotifiableItemStackHandler {
        public LimitedImportHandler() {
            super(1, null, false);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int slotLimit;
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!ItemStackHashStrategy.comparingAllButCount().equals(stack, this.getStackInSlot(slot)) && !this.getStackInSlot(slot).func_190926_b()) {
                return stack;
            }
            int amountInSlot = this.getStackInSlot(slot).func_190916_E();
            if (amountInSlot >= (slotLimit = this.getSlotLimit(slot))) {
                return stack;
            }
            int spaceAvailable = slotLimit - amountInSlot;
            int amountToInsert = Math.min(spaceAvailable, stack.func_190916_E());
            int remainderAmount = stack.func_190916_E() - amountToInsert;
            ItemStack remainder = ItemStack.field_190927_a;
            if (remainderAmount > 0) {
                remainder = stack.func_77946_l();
                remainder.func_190920_e(remainderAmount);
            }
            if (!simulate) {
                ItemStack temp = stack.func_77946_l();
                temp.func_190920_e(amountInSlot + amountToInsert);
                this.setStackInSlot(slot, temp);
            }
            return remainder;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            boolean slotMatches = this.getStackInSlot(slot).func_190926_b() || ItemStackHashStrategy.comparingAllButCount().equals(this.getStackInSlot(slot), stack);
            MultiblockControllerBase controller = MetaTileEntityMachineHatch.this.getController();
            if (controller instanceof IMachineHatchMultiblock) {
                return slotMatches && GTUtility.isMachineValidForMachineHatch(stack, ((IMachineHatchMultiblock)((Object)controller)).getBlacklist());
            }
            return slotMatches;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            RecipeMapMultiblockController controller;
            if (MetaTileEntityMachineHatch.this.getController() instanceof RecipeMapMultiblockController && (controller = (RecipeMapMultiblockController)MetaTileEntityMachineHatch.this.getController()) != null && controller.isActive()) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Override
        public <T> void addToNotifiedList(MetaTileEntity metaTileEntity, T handler, boolean isExport) {
            if (metaTileEntity instanceof IMachineHatchMultiblock && metaTileEntity.isValid()) {
                ((IMachineHatchMultiblock)((Object)metaTileEntity)).notifyMachineChanged();
            }
        }

        public int getSlotLimit(int slot) {
            return MetaTileEntityMachineHatch.this.getMachineLimit();
        }
    }
}

