/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IPrimitivePump;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class MetaTileEntityPrimitiveWaterPump
extends MultiblockControllerBase
implements IPrimitivePump {
    private IFluidTank waterTank;
    private int biomeModifier = 0;
    private int hatchModifier = 0;

    public MetaTileEntityPrimitiveWaterPump(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.resetTileAbilities();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPrimitiveWaterPump(this.metaTileEntityId);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 20L == 0L && this.isStructureFormed()) {
            if (this.biomeModifier == 0) {
                this.biomeModifier = this.getAmount();
            } else if (this.biomeModifier > 0) {
                this.waterTank.fill(Materials.Water.getFluid(this.getFluidProduction()), true);
            }
        }
    }

    private int getAmount() {
        WorldProvider provider = this.getWorld().field_73011_w;
        if (provider.func_177495_o() || provider.func_177500_n()) {
            return -1;
        }
        Biome biome = this.getWorld().func_180494_b(this.getPos());
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (biomeTypes.contains(BiomeDictionary.Type.NETHER)) {
            return -1;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.WATER)) {
            return 1000;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.SWAMP) || biomeTypes.contains(BiomeDictionary.Type.WET)) {
            return 800;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.JUNGLE)) {
            return 350;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.SNOWY)) {
            return 300;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.PLAINS) || biomeTypes.contains(BiomeDictionary.Type.FOREST)) {
            return 250;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.COLD)) {
            return 175;
        }
        if (biomeTypes.contains(BiomeDictionary.Type.BEACH)) {
            return 170;
        }
        return 100;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected void updateFormedValid() {
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    private void initializeAbilities() {
        List<IFluidTank> tanks = this.getAbilities(MultiblockAbility.PUMP_FLUID_HATCH);
        this.hatchModifier = tanks == null || tanks.size() == 0 ? ((tanks = this.getAbilities(MultiblockAbility.EXPORT_FLUIDS)).get(0).getCapacity() == 8000 ? 2 : 4) : 1;
        this.waterTank = tanks.get(0);
    }

    private void resetTileAbilities() {
        this.waterTank = new FluidTank(0);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXXX", "**F*", "**F*").aisle("XXHX", "F**F", "FFFF").aisle("SXXX", "**F*", "**F*").where('S', this.selfPredicate()).where('X', MetaTileEntityPrimitiveWaterPump.states(MetaBlocks.STEAM_CASING.getState(BlockSteamCasing.SteamCasingType.PUMP_DECK))).where('F', MetaTileEntityPrimitiveWaterPump.frames(Materials.TreatedWood)).where('H', MetaTileEntityPrimitiveWaterPump.abilities(MultiblockAbility.PUMP_FLUID_HATCH).or(MetaTileEntityPrimitiveWaterPump.metaTileEntities(MetaTileEntities.FLUID_EXPORT_HATCH[0], MetaTileEntities.FLUID_EXPORT_HATCH[1]))).where('*', MetaTileEntityPrimitiveWaterPump.any()).build();
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PRIMITIVE_PUMP;
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PRIMITIVE_PUMP_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), true, true);
    }

    @Override
    public String[] getDescription() {
        return (String[])Stream.of({I18n.func_135052_a((String)"gregtech.multiblock.primitive_water_pump.description", (Object[])new Object[0])}, I18n.func_135052_a((String)"gregtech.multiblock.primitive_water_pump.extra1", (Object[])new Object[0]).split("/n"), I18n.func_135052_a((String)"gregtech.multiblock.primitive_water_pump.extra2", (Object[])new Object[0]).split("/n")).flatMap(Stream::of).toArray(String[]::new);
    }

    private boolean isRainingInBiome() {
        World world = this.getWorld();
        if (!world.func_72896_J()) {
            return false;
        }
        return world.func_180494_b(this.getPos()).func_76738_d();
    }

    @Override
    public int getFluidProduction() {
        return (int)((double)(this.biomeModifier * this.hatchModifier) * (this.isRainingInBiome() ? 1.5 : 1.0));
    }
}

