/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.armor.Jetpack;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedJetpack
extends Jetpack {
    public AdvancedJetpack(int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, @Nonnull ItemStack item) {
        byte toggleTimer;
        IElectricItem cont = (IElectricItem)item.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (cont == null) {
            return;
        }
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(item);
        boolean hoverMode = data.func_74764_b("hover") && data.func_74767_n("hover");
        byte by = toggleTimer = data.func_74764_b("toggleTimer") ? data.func_74771_c("toggleTimer") : (byte)0;
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hoverMode = !hoverMode;
            toggleTimer = 5;
            data.func_74757_a("hover", hoverMode);
            if (!world.field_72995_K) {
                if (hoverMode) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.enable", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.disable", new Object[0]), true);
                }
            }
        }
        this.performFlying(player, hoverMode, item);
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.func_74757_a("hover", hoverMode);
        data.func_74774_a("toggleTimer", toggleTimer);
        player.field_71069_bz.func_75142_b();
    }

    @Override
    public double getSprintEnergyModifier() {
        return 2.5;
    }

    @Override
    public double getSprintSpeedModifier() {
        return 1.3;
    }

    @Override
    public double getVerticalHoverSpeed() {
        return 0.34;
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.03;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.13;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.48;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.14;
    }

    @Override
    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.CLOUD;
    }

    @Override
    public float getFallDamageReduction() {
        return 2.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isNeedDrawHUD() {
        return true;
    }

    @Override
    public void drawHUD(ItemStack item) {
        super.addCapacityHUD(item);
        IElectricItem cont = (IElectricItem)item.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (cont == null) {
            return;
        }
        if (!cont.canUse(this.energyPerUse)) {
            return;
        }
        NBTTagCompound data = item.func_77978_p();
        if (data != null && data.func_74764_b("hover")) {
            String status = data.func_74767_n("hover") ? "metaarmor.hud.status.enabled" : "metaarmor.hud.status.disabled";
            this.HUD.newString(I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{I18n.func_135052_a((String)status, (Object[])new Object[0])}));
        }
        this.HUD.draw();
        this.HUD.reset();
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/advanced_jetpack.png";
    }
}

