/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource.sources;

import gregtech.api.recipes.KeySharedStack;
import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.itemsource.ItemSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryItemSource
extends ItemSource {
    protected final World world;
    protected final int priority;
    protected IItemHandler itemHandler = EmptyHandler.INSTANCE;
    private Map<ItemStackKey, Integer> itemStackByAmountMap = new LinkedHashMap<ItemStackKey, Integer>();

    public InventoryItemSource(World world, int priority) {
        this.world = world;
        this.priority = priority;
    }

    public InventoryItemSource(World world, IItemHandler itemHandler1, int priority) {
        this(world, priority);
        this.itemHandler = itemHandler1;
    }

    @Override
    public void computeItemHandler() {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void update() {
        this.recomputeItemStackCount();
    }

    @Override
    public int insertItem(ItemStackKey itemStackKey, int amount, boolean simulate, Object2IntMap<ItemSource> insertedMap) {
        int itemsInserted = 0;
        if (this.itemHandler == null) {
            return itemsInserted;
        }
        ItemStack itemStack = itemStackKey.getItemStack();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemStack.func_190920_e(amount - itemsInserted);
            ItemStack remainderStack = this.itemHandler.insertItem(i, itemStack, simulate);
            if ((itemsInserted += itemStack.func_190916_E() - remainderStack.func_190916_E()) == amount) break;
        }
        if (itemsInserted > 0 && !simulate) {
            int finalItemsInserted = itemsInserted;
            insertedMap.computeIfPresent((Object)this, (source, count) -> count + finalItemsInserted);
            insertedMap.putIfAbsent((Object)this, (Object)amount);
        }
        return itemsInserted;
    }

    @Override
    public int extractItem(ItemStackKey itemStackKey, int amount, boolean simulate, Object2IntMap<ItemSource> extractedMap) {
        int itemsExtracted = 0;
        if (this.itemHandler == null) {
            return itemsExtracted;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !itemStackKey.isItemStackEqual(stackInSlot)) continue;
            ItemStack extractedStack = this.itemHandler.extractItem(i, amount - itemsExtracted, simulate);
            if (!extractedStack.func_190926_b()) {
                itemsExtracted += extractedStack.func_190916_E();
            }
            if (itemsExtracted == amount) break;
        }
        if (itemsExtracted > 0 && !simulate) {
            int finalItemsExtracted = itemsExtracted;
            extractedMap.computeIfPresent((Object)this, (source, count) -> count + finalItemsExtracted);
            extractedMap.putIfAbsent((Object)this, (Object)amount);
        }
        return itemsExtracted;
    }

    @Override
    public Map<ItemStackKey, Integer> getStoredItems() {
        return Collections.unmodifiableMap(this.itemStackByAmountMap);
    }

    private void recomputeItemStackCount() {
        LinkedHashMap<ItemStackKey, Integer> amountMap = new LinkedHashMap<ItemStackKey, Integer>();
        if (this.itemHandler == null) {
            this.itemStackByAmountMap = amountMap;
            return;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, true);
            if (itemStack.func_190926_b()) continue;
            ItemStackKey stackKey = KeySharedStack.getRegisteredStack(itemStack);
            amountMap.put(stackKey, ((HashMap)amountMap).getOrDefault(stackKey, 0) + itemStack.func_190916_E());
        }
        this.itemStackByAmountMap = amountMap;
    }
}

