/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SliderWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.client.renderer.texture.Textures;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CoverMachineController
extends CoverBehavior
implements CoverWithUI {
    private int minRedstoneStrength = 1;
    private boolean isInverted = false;
    private ControllerMode controllerMode;
    private final ItemStackHandler displayInventory = new ItemStackHandler(1);

    public CoverMachineController(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
        this.controllerMode = ControllerMode.MACHINE;
    }

    public int getMinRedstoneStrength() {
        return this.minRedstoneStrength;
    }

    public ControllerMode getControllerMode() {
        return this.controllerMode;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public void setMinRedstoneStrength(int minRedstoneStrength) {
        this.minRedstoneStrength = minRedstoneStrength;
        this.updateRedstoneStatus();
        this.coverHolder.markDirty();
    }

    public void setInverted(boolean inverted) {
        this.isInverted = inverted;
        this.updateRedstoneStatus();
        this.coverHolder.markDirty();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.resetCurrentControllable();
        this.controllerMode = controllerMode;
        this.updateRedstoneStatus();
        this.updateDisplayInventory();
        this.coverHolder.markDirty();
    }

    private void cycleNextControllerMode() {
        List<ControllerMode> allowedModes = this.getAllowedModes();
        int nextIndex = allowedModes.indexOf((Object)this.controllerMode) + 1;
        if (!allowedModes.isEmpty()) {
            this.setControllerMode(allowedModes.get(nextIndex % allowedModes.size()));
        }
    }

    public List<ControllerMode> getAllowedModes() {
        ArrayList<ControllerMode> results = new ArrayList<ControllerMode>();
        for (ControllerMode controllerMode : ControllerMode.values()) {
            IControllable controllable = null;
            if (controllerMode.side == null) {
                controllable = this.coverHolder.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, this.attachedSide);
            } else {
                CoverBehavior coverBehavior = this.coverHolder.getCoverAtSide(controllerMode.side);
                if (coverBehavior != null) {
                    controllable = coverBehavior.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
                }
            }
            if (controllable == null) continue;
            results.add(controllerMode);
        }
        return results;
    }

    @Override
    public boolean canAttach() {
        return !this.getAllowedModes().isEmpty();
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        this.updateDisplayInventory();
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 95).image(4, 4, 16, 16, GuiTextures.COVER_MACHINE_CONTROLLER).label(24, 8, "cover.machine_controller.title").widget(new SliderWidget("cover.machine_controller.redstone", 10, 24, 156, 20, 1.0f, 15.0f, this.minRedstoneStrength, it -> this.setMinRedstoneStrength((int)it))).widget(new ClickButtonWidget(10, 48, 134, 18, "", data -> this.cycleNextControllerMode())).widget(new SimpleTextWidget(77, 58, "", 0xFFFFFF, () -> this.getControllerMode().func_176610_l()).setShadow(true)).widget(new SlotWidget((IItemHandler)this.displayInventory, 0, 148, 48, false, false).setBackgroundTexture(GuiTextures.SLOT)).widget(new CycleButtonWidget(48, 70, 80, 18, this::isInverted, this::setInverted, "cover.machine_controller.normal", "cover.machine_controller.inverted").setTooltipHoverString("cover.machine_controller.inverted.description")).build(this, player);
    }

    @Override
    public void onAttached(ItemStack itemStack) {
        super.onAttached(itemStack);
        this.controllerMode = this.getAllowedModes().iterator().next();
        this.updateRedstoneStatus();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.resetCurrentControllable();
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.MACHINE_CONTROLLER_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void onRedstoneInputSignalChange(int newSignalStrength) {
        this.updateRedstoneStatus();
    }

    private void updateDisplayInventory() {
        CoverBehavior coverBehavior;
        EnumFacing controlledSide = this.getControllerMode().side;
        ItemStack resultStack = ItemStack.field_190927_a;
        if (controlledSide != null && (coverBehavior = this.coverHolder.getCoverAtSide(controlledSide)) != null) {
            resultStack = coverBehavior.getCoverDefinition().getDropItemStack();
        }
        this.displayInventory.setStackInSlot(0, resultStack);
    }

    private IControllable getControllable() {
        EnumFacing side = this.controllerMode.side;
        if (side == null) {
            return this.coverHolder.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, this.attachedSide);
        }
        CoverBehavior coverBehavior = this.coverHolder.getCoverAtSide(side);
        if (coverBehavior == null) {
            return null;
        }
        return coverBehavior.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
    }

    private void resetCurrentControllable() {
        IControllable controllable = this.getControllable();
        if (controllable != null) {
            controllable.setWorkingEnabled(this.doesOtherAllowingWork());
        }
    }

    private void updateRedstoneStatus() {
        IControllable controllable = this.getControllable();
        if (controllable != null) {
            controllable.setWorkingEnabled(this.shouldAllowWorking() && this.doesOtherAllowingWork());
        }
    }

    private boolean shouldAllowWorking() {
        boolean shouldAllowWorking;
        boolean bl = shouldAllowWorking = this.getRedstoneSignalInput() < this.minRedstoneStrength;
        return this.isInverted ? !shouldAllowWorking : shouldAllowWorking;
    }

    private boolean doesOtherAllowingWork() {
        boolean otherAllow = true;
        for (EnumFacing side : EnumFacing.values()) {
            if (side == this.attachedSide || !(this.coverHolder.getCoverAtSide(side) instanceof CoverMachineController)) continue;
            CoverMachineController cover = (CoverMachineController)this.coverHolder.getCoverAtSide(side);
            otherAllow = otherAllow && cover.controllerMode == this.controllerMode && cover.shouldAllowWorking();
        }
        return otherAllow;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("MinRedstoneStrength", this.minRedstoneStrength);
        tagCompound.func_74757_a("Inverted", this.isInverted);
        tagCompound.func_74768_a("ControllerMode", this.controllerMode.ordinal());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.minRedstoneStrength = tagCompound.func_74762_e("MinRedstoneStrength");
        this.isInverted = tagCompound.func_74767_n("Inverted");
        this.controllerMode = ControllerMode.values()[tagCompound.func_74762_e("ControllerMode")];
    }

    public static enum ControllerMode implements IStringSerializable
    {
        MACHINE("cover.machine_controller.mode.machine", null),
        COVER_UP("cover.machine_controller.mode.cover_up", EnumFacing.UP),
        COVER_DOWN("cover.machine_controller.mode.cover_down", EnumFacing.DOWN),
        COVER_NORTH("cover.machine_controller.mode.cover_north", EnumFacing.NORTH),
        COVER_SOUTH("cover.machine_controller.mode.cover_south", EnumFacing.SOUTH),
        COVER_EAST("cover.machine_controller.mode.cover_east", EnumFacing.EAST),
        COVER_WEST("cover.machine_controller.mode.cover_west", EnumFacing.WEST);

        public final String localeName;
        public final EnumFacing side;

        private ControllerMode(String localeName, EnumFacing side) {
            this.localeName = localeName;
            this.side = side;
        }

        @Nonnull
        public String func_176610_l() {
            return this.localeName;
        }
    }
}

