/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.command;

import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.items.materialitem.MetaPrefixItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.items.MetaItems;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CommandRecipeCheck
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "recipecheck";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "gregtech.command.util.recipecheck.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.recipecheck.begin", new Object[0]));
        Object2ObjectOpenHashMap mismatchedRecipes = new Object2ObjectOpenHashMap();
        GTLog.logger.info("[Recipe Checker] Starting recipe conflict check...");
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            mismatchedRecipes.put(recipeMap, (Object)new Object2ObjectOpenHashMap());
            GTLog.logger.info("Checking Recipe Map: {}", (Object)recipeMap.unlocalizedName);
            for (Recipe currentRecipe : recipeMap.getRecipeList()) {
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                for (GTRecipeInput input : currentRecipe.getInputs()) {
                    for (ItemStack stack2 : input.getInputStacks()) {
                        stack2 = stack2.func_77946_l();
                        stack2.func_190920_e(Integer.MAX_VALUE);
                        inputs.add(stack2);
                    }
                }
                List<FluidStack> fluidInputs = currentRecipe.getFluidInputs().stream().map(stack -> new FluidStack(stack.getInputFluidStack(), Integer.MAX_VALUE)).collect(Collectors.toList());
                Set<Recipe> collidingRecipeSet = recipeMap.findRecipeCollisions(inputs, fluidInputs);
                if (collidingRecipeSet == null) {
                    GTLog.logger.error("This recipe returned null for findRecipeCollisions: {}", (Object)this.prettyPrintRecipe(currentRecipe));
                    continue;
                }
                if (collidingRecipeSet.size() <= 1) continue;
                collidingRecipeSet.remove(currentRecipe);
                Object2ObjectOpenHashMap conflictingRecipeMap = (Object2ObjectOpenHashMap)mismatchedRecipes.get(recipeMap);
                collidingRecipeSet.removeIf(cf -> conflictingRecipeMap.get(cf) != null && ((Set)conflictingRecipeMap.get(cf)).contains(currentRecipe));
                if (collidingRecipeSet.size() <= 0) continue;
                ((Object2ObjectOpenHashMap)mismatchedRecipes.get(recipeMap)).put((Object)currentRecipe, collidingRecipeSet);
            }
            if (((Object2ObjectOpenHashMap)mismatchedRecipes.get(recipeMap)).isEmpty()) {
                GTLog.logger.info("No mismatched recipes found for recipe map: {}", (Object)recipeMap.unlocalizedName);
                mismatchedRecipes.remove(recipeMap);
                continue;
            }
            GTLog.logger.error("Mismatched recipes found for recipe map: {}", (Object)recipeMap.unlocalizedName);
        }
        GTLog.logger.info("[Recipe Checker] Completed recipe check!");
        int count = 0;
        if (mismatchedRecipes.size() == 0) {
            GTLog.logger.info("No recipe conflicts found in all recipe maps!");
        } else {
            count = (int)mismatchedRecipes.values().stream().mapToLong(s -> s.values().stream().mapToLong(Set::size).sum()).sum();
            GTLog.logger.info("[Recipe Checker] Found {} potential conflicts", (Object)count);
            for (Map.Entry recipeMap : mismatchedRecipes.entrySet()) {
                GTLog.logger.error("\n[In Recipe map] :\"{}\"", (Object)((RecipeMap)recipeMap.getKey()).unlocalizedName);
                for (Map.Entry reciper : ((Object2ObjectOpenHashMap)mismatchedRecipes.get(recipeMap.getKey())).entrySet()) {
                    StringBuilder conflictingRecipes = new StringBuilder();
                    conflictingRecipes.append("\n[Tried matching]: ").append(this.prettyPrintRecipe((Recipe)reciper.getKey()));
                    for (Recipe c : (Set)reciper.getValue()) {
                        conflictingRecipes.append("\n[Also Found]: ").append(this.prettyPrintRecipe(c));
                    }
                    GTLog.logger.error(conflictingRecipes.toString());
                }
            }
        }
        if (mismatchedRecipes.size() == 0) {
            sender.func_145747_a(new TextComponentTranslation("gregtech.command.recipecheck.end_no_conflicts", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.recipecheck.end", new Object[]{count}));
        }
    }

    public String prettyPrintRecipe(Recipe recipe) {
        if (recipe == null) {
            return "null (Is something else going wrong?)\n";
        }
        StringBuilder output = new StringBuilder();
        output.append("EU/t: ").append(recipe.getEUt()).append(", Duration: ").append(recipe.getDuration());
        if (recipe.isHidden()) {
            output.append(", hidden");
        }
        output.append("\n");
        if (recipe.getInputs().size() > 0) {
            output.append("Item inputs:\n");
            for (GTRecipeInput ingredient : recipe.getInputs()) {
                output.append("    ").append(this.prettyPrintRecipeInput(ingredient)).append("\n");
            }
        }
        if (recipe.getFluidInputs().size() > 0) {
            output.append("Fluid inputs:\n");
            for (GTRecipeInput fluid : recipe.getFluidInputs()) {
                output.append("    ").append(fluid.getInputFluidStack().getUnlocalizedName()).append(" * ").append(fluid.getAmount()).append("\n");
            }
        }
        if (recipe.getOutputs().size() > 0) {
            output.append("Item outputs:\n");
            for (ItemStack stack : recipe.getOutputs()) {
                output.append("    ").append(this.prettyPrintItemStack(stack)).append("\n");
            }
        }
        if (recipe.getChancedOutputs().size() > 0) {
            output.append("Item chanced outputs:\n");
            for (Recipe.ChanceEntry chanceEntry : recipe.getChancedOutputs()) {
                output.append("    ").append(this.prettyPrintItemStack(chanceEntry.getItemStack())).append(" (Chance: ").append(chanceEntry.getChance()).append(", Boost: ").append(chanceEntry.getBoostPerTier()).append(")\n");
            }
        }
        if (recipe.getFluidOutputs().size() > 0) {
            output.append("Fluid outputs:\n");
            for (GTRecipeInput fluid : recipe.getFluidOutputs()) {
                output.append("    ").append(fluid.getUnlocalizedName()).append(" * ").append(((FluidStack)fluid).amount).append("\n");
            }
        }
        return output.toString();
    }

    public String prettyPrintRecipeInput(GTRecipeInput recipeInput) {
        ItemStack[] matchingStacks;
        StringBuilder output = new StringBuilder();
        if (recipeInput.isOreDict()) {
            output.append("(OreDict: ").append("\"").append(OreDictionary.getOreName((int)recipeInput.getOreDict())).append("\")");
        }
        output.append(" { ");
        for (ItemStack stack : matchingStacks = recipeInput.getInputStacks()) {
            output.append(" ").append(this.prettyPrintItemStack(stack)).append(",");
        }
        if (matchingStacks.length > 0) {
            output.delete(output.lastIndexOf(","), output.length());
        }
        output.append(" } * ").append(recipeInput.getAmount());
        return output.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String prettyPrintItemStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)stack.func_77973_b();
            Object metaValueItem = metaItem.getItem(stack);
            if (metaValueItem == null) {
                if (!(metaItem instanceof MetaPrefixItem)) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
                Material material = ((MetaPrefixItem)metaItem).getMaterial(stack);
                OrePrefix orePrefix = ((MetaPrefixItem)metaItem).getOrePrefix();
                return "(MetaItem) OrePrefix: " + orePrefix.name + ", Material: " + material + " * " + stack.func_190916_E();
            }
            if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(stack)) return "(MetaItem) " + ((MetaItem.MetaValueItem)metaValueItem).unlocalizedName + " * " + stack.func_190916_E();
            return "Config circuit #" + IntCircuitIngredient.getCircuitConfiguration(stack);
        }
        if (stack.func_77973_b() instanceof MachineItemBlock) {
            MetaTileEntity mte = GTUtility.getMetaTileEntity(stack);
            if (mte == null) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
            String id = mte.metaTileEntityId.toString();
            if (!mte.metaTileEntityId.func_110624_b().equals("gregtech")) return "(MetaTileEntity) " + id + " * " + stack.func_190916_E();
            id = mte.metaTileEntityId.func_110623_a();
            return "(MetaTileEntity) " + id + " * " + stack.func_190916_E();
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        String id = null;
        if (block instanceof BlockCompressed) {
            id = "block" + ((BlockCompressed)block).getGtMaterial(stack.func_77960_j()).toCamelCaseString();
        } else if (block instanceof BlockFrame) {
            id = "frame" + ((BlockFrame)block).getGtMaterial(stack.func_77960_j()).toCamelCaseString();
        } else if (block instanceof BlockMaterialPipe) {
            id = ((BlockMaterialPipe)block).getPrefix().name + ((BlockMaterialPipe)block).getItemMaterial(stack).toCamelCaseString();
        }
        if (id == null) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
        return "(MetaBlock) " + id + " * " + stack.func_190916_E();
    }
}

