/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyMaterial
extends PropertyHelper<Material> {
    private final ImmutableList<Material> allowedValues;

    protected PropertyMaterial(String name, Collection<? extends Material> allowedValues) {
        super(name, Material.class);
        this.allowedValues = ImmutableList.copyOf(allowedValues);
    }

    public static PropertyMaterial create(String name, Collection<? extends Material> allowedValues) {
        return new PropertyMaterial(name, allowedValues);
    }

    public static PropertyMaterial create(String name, Material[] allowedValues) {
        return new PropertyMaterial(name, Arrays.asList(allowedValues));
    }

    @Nonnull
    public ImmutableList<Material> getAllowedValues() {
        return this.allowedValues;
    }

    @Nonnull
    public Optional<Material> func_185929_b(@Nonnull String value) {
        Material material = (Material)GregTechAPI.MATERIAL_REGISTRY.func_82594_a(value);
        if (this.allowedValues.contains((Object)material)) {
            return Optional.of((Object)material);
        }
        return Optional.of((Object)Materials.NULL);
    }

    @Nonnull
    public String getName(Material material) {
        return material.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyMaterial) {
            PropertyMaterial propertyMaterial = (PropertyMaterial)((Object)obj);
            return this.allowedValues.equals(propertyMaterial.allowedValues);
        }
        return false;
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.allowedValues.hashCode();
        return i;
    }
}

