/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.shader.postprocessing;

import gregtech.client.shader.PingPongBuffer;
import gregtech.client.shader.Shaders;
import gregtech.client.shader.postprocessing.BlurEffect;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BloomEffect {
    private static Framebuffer[] BUFFERS_D;
    private static Framebuffer[] BUFFERS_U;
    public static float strength;
    public static float baseBrightness;
    public static float highBrightnessThreshold;
    public static float lowBrightnessThreshold;
    public static float step;

    private static void blend(Framebuffer bloom, Framebuffer backgroundFBO) {
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        backgroundFBO.func_147612_c();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179098_w();
        bloom.func_147612_c();
        Shaders.renderFullImageInFBO(PingPongBuffer.swap(), Shaders.BLOOM_COMBINE, uniformCache -> {
            uniformCache.glUniform1I("buffer_a", 0);
            uniformCache.glUniform1I("buffer_b", 1);
            uniformCache.glUniform1F("intensive", strength);
            uniformCache.glUniform1F("base", baseBrightness);
            uniformCache.glUniform1F("threshold_up", highBrightnessThreshold);
            uniformCache.glUniform1F("threshold_down", lowBrightnessThreshold);
        });
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179144_i((int)0);
        PingPongBuffer.bindFramebufferTexture();
    }

    private static void cleanUP(int lastWidth, int lastHeight) {
        if (BUFFERS_D == null || BUFFERS_D.length != ConfigHolder.client.shader.nMips) {
            if (BUFFERS_D != null) {
                for (int i = 0; i < BUFFERS_D.length; ++i) {
                    BUFFERS_D[i].func_147608_a();
                    BUFFERS_U[i].func_147608_a();
                }
            }
            BUFFERS_D = new Framebuffer[ConfigHolder.client.shader.nMips];
            BUFFERS_U = new Framebuffer[ConfigHolder.client.shader.nMips];
            int resX = lastWidth / 2;
            int resY = lastHeight / 2;
            for (int i = 0; i < ConfigHolder.client.shader.nMips; ++i) {
                BloomEffect.BUFFERS_D[i] = new Framebuffer(resX, resY, false);
                BloomEffect.BUFFERS_U[i] = new Framebuffer(resX, resY, false);
                BUFFERS_D[i].func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
                BUFFERS_U[i].func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
                BUFFERS_D[i].func_147607_a(9729);
                BUFFERS_U[i].func_147607_a(9729);
                resX /= 2;
                resY /= 2;
            }
        } else if (RenderUtil.updateFBOSize(BUFFERS_D[0], lastWidth / 2, lastHeight / 2)) {
            int resX = lastWidth / 2;
            int resY = lastHeight / 2;
            for (int i = 0; i < ConfigHolder.client.shader.nMips; ++i) {
                RenderUtil.updateFBOSize(BUFFERS_D[i], resX, resY);
                RenderUtil.updateFBOSize(BUFFERS_U[i], resX, resY);
                BUFFERS_D[i].func_147607_a(9729);
                BUFFERS_U[i].func_147607_a(9729);
                resX /= 2;
                resY /= 2;
            }
        }
        PingPongBuffer.updateSize(lastWidth, lastHeight);
    }

    public static void renderLOG(Framebuffer highLightFBO, Framebuffer backgroundFBO) {
        PingPongBuffer.updateSize(backgroundFBO.field_147621_c, backgroundFBO.field_147618_d);
        BlurEffect.updateSize(backgroundFBO.field_147621_c, backgroundFBO.field_147618_d);
        highLightFBO.func_147612_c();
        BloomEffect.blend(BlurEffect.renderBlur1(step), backgroundFBO);
    }

    public static void renderUnity(Framebuffer highLightFBO, Framebuffer backgroundFBO) {
        int i;
        BloomEffect.cleanUP(backgroundFBO.field_147621_c, backgroundFBO.field_147618_d);
        BloomEffect.renderDownSampling(highLightFBO, BUFFERS_D[0]);
        for (i = 0; i < BUFFERS_D.length - 1; ++i) {
            BloomEffect.renderDownSampling(BUFFERS_D[i], BUFFERS_D[i + 1]);
        }
        BloomEffect.renderUpSampling(BUFFERS_D[BUFFERS_D.length - 1], BUFFERS_D[BUFFERS_D.length - 2], BUFFERS_U[BUFFERS_D.length - 2]);
        for (i = BUFFERS_U.length - 2; i > 0; --i) {
            BloomEffect.renderUpSampling(BUFFERS_U[i], BUFFERS_D[i - 1], BUFFERS_U[i - 1]);
        }
        BloomEffect.renderUpSampling(BUFFERS_U[0], highLightFBO, PingPongBuffer.swap());
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179144_i((int)0);
        BloomEffect.blend(PingPongBuffer.getCurrentBuffer(false), backgroundFBO);
    }

    private static void renderDownSampling(Framebuffer U, Framebuffer D) {
        U.func_147612_c();
        Shaders.renderFullImageInFBO(D, Shaders.DOWN_SAMPLING, uniformCache -> uniformCache.glUniform2F("u_resolution2", (float)U.field_147621_c, (float)U.field_147618_d));
    }

    private static void renderUpSampling(Framebuffer U, Framebuffer D, Framebuffer T) {
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        U.func_147612_c();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179098_w();
        D.func_147612_c();
        Shaders.renderFullImageInFBO(T, Shaders.UP_SAMPLING, uniformCache -> {
            uniformCache.glUniform1I("upTexture", 0);
            uniformCache.glUniform1I("downTexture", 1);
            uniformCache.glUniform2F("u_resolution2", (float)U.field_147621_c, (float)U.field_147618_d);
        });
    }

    public static void renderUnreal(Framebuffer highLightFBO, Framebuffer backgroundFBO) {
        int i;
        BloomEffect.cleanUP(backgroundFBO.field_147621_c, backgroundFBO.field_147618_d);
        int[] kernelSizeArray = new int[]{3, 5, 7, 9, 11};
        highLightFBO.func_147612_c();
        for (i = 0; i < BUFFERS_D.length; ++i) {
            Framebuffer buffer_h = BUFFERS_D[i];
            int kernel = kernelSizeArray[i];
            Shaders.renderFullImageInFBO(buffer_h, Shaders.S_BLUR, uniformCache -> {
                uniformCache.glUniform2F("texSize", (float)buffer_h.field_147621_c, (float)buffer_h.field_147618_d);
                uniformCache.glUniform2F("blurDir", step, 0.0f);
                uniformCache.glUniform1I("kernel_radius", kernel);
            }).func_147612_c();
            Framebuffer buffer_v = BUFFERS_U[i];
            Shaders.renderFullImageInFBO(buffer_v, Shaders.S_BLUR, uniformCache -> {
                uniformCache.glUniform2F("texSize", (float)buffer_v.field_147621_c, (float)buffer_v.field_147618_d);
                uniformCache.glUniform2F("blurDir", 0.0f, step);
                uniformCache.glUniform1I("kernel_radius", kernel);
            }).func_147612_c();
        }
        for (i = 0; i < BUFFERS_D.length; ++i) {
            GlStateManager.func_179138_g((int)(33984 + i));
            GlStateManager.func_179098_w();
            BUFFERS_U[i].func_147612_c();
        }
        Shaders.renderFullImageInFBO(BUFFERS_D[0], Shaders.COMPOSITE, uniformCache -> {
            uniformCache.glUniform1I("blurTexture1", 0);
            uniformCache.glUniform1I("blurTexture2", 1);
            uniformCache.glUniform1I("blurTexture3", 2);
            uniformCache.glUniform1I("blurTexture4", 3);
            uniformCache.glUniform1I("blurTexture5", 4);
            uniformCache.glUniform1F("bloomStrength", strength);
            uniformCache.glUniform1F("bloomRadius", 1.0f);
        });
        for (i = BUFFERS_D.length - 1; i >= 0; --i) {
            GlStateManager.func_179138_g((int)(33984 + i));
            GlStateManager.func_179144_i((int)0);
        }
        BloomEffect.blend(BUFFERS_D[0], backgroundFBO);
    }

    static {
        strength = (float)ConfigHolder.client.shader.strength;
        baseBrightness = (float)ConfigHolder.client.shader.baseBrightness;
        highBrightnessThreshold = (float)ConfigHolder.client.shader.highBrightnessThreshold;
        lowBrightnessThreshold = (float)ConfigHolder.client.shader.lowBrightnessThreshold;
        step = (float)ConfigHolder.client.shader.step;
    }
}

