/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.customtexture;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gregtech.api.util.GTLog;
import gregtech.asm.hooks.CTMHooks;
import gregtech.client.model.customtexture.CustomTexture;
import gregtech.client.model.customtexture.CustomTextureBakedModel;
import gregtech.client.model.customtexture.CustomTextureModelHandler;
import gregtech.client.model.customtexture.MetadataSectionCTM;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CustomTextureModel
implements IModel {
    private final ModelBlock modelInfo;
    private final IModel vanillaModel;
    private Boolean uvLock;
    private final Collection<ResourceLocation> textureDependencies;
    private final Map<String, CustomTexture> textures = new HashMap<String, CustomTexture>();
    private transient byte layers;
    private static final MethodHandle _asVanillaModel;

    public CustomTextureModel(ModelBlock modelInfo, IModel vanillaModel) {
        this.modelInfo = modelInfo;
        this.vanillaModel = vanillaModel;
        this.textureDependencies = new HashSet<ResourceLocation>();
        this.textureDependencies.addAll(vanillaModel.getTextures());
        this.textureDependencies.removeIf(rl -> rl.func_110623_a().startsWith("#"));
    }

    public IModel getVanillaParent() {
        return this.vanillaModel;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        boolean flag = this.layers < 0 && state.func_177230_c().func_180664_k() == layer || (this.layers >> layer.ordinal() & 1) == 1;
        return CTMHooks.checkLayerWithOptiFine(flag, this.layers, layer);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel parent = this.vanillaModel.bake(state, format, rl -> {
            TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply((ResourceLocation)rl);
            MetadataSectionCTM meta = null;
            try {
                meta = CustomTextureModelHandler.getMetadata(sprite);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MetadataSectionCTM finalMeta = meta;
            this.textures.computeIfAbsent(sprite.func_94215_i(), s -> {
                CustomTexture tex = new CustomTexture(finalMeta);
                this.layers = (byte)(this.layers | 1 << (tex.getLayer() == null ? 7 : tex.getLayer().ordinal()));
                return tex;
            });
            return sprite;
        });
        return new CustomTextureBakedModel(this, parent);
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptySet();
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return this.textureDependencies;
    }

    @Nonnull
    public IModelState getDefaultState() {
        return this.getVanillaParent().getDefaultState();
    }

    @Nonnull
    public Optional<? extends IClip> getClip(@Nonnull String name) {
        return this.getVanillaParent().getClip(name);
    }

    @Nonnull
    public IModel process(@Nonnull ImmutableMap<String, String> customData) {
        return this.deepCopyOrMissing(this.getVanillaParent().process(customData), null, null);
    }

    @Nonnull
    public IModel smoothLighting(boolean value) {
        if (this.modelInfo.func_178309_b() != value) {
            return this.deepCopyOrMissing(this.getVanillaParent().smoothLighting(value), value, null);
        }
        return this;
    }

    public CustomTexture getTexture(String iconName) {
        return this.textures.get(iconName);
    }

    @Nonnull
    public IModel gui3d(boolean value) {
        if (this.modelInfo.func_178311_c() != value) {
            return this.deepCopyOrMissing(this.getVanillaParent().gui3d(value), null, value);
        }
        return this;
    }

    @Nonnull
    public IModel uvlock(boolean value) {
        IModel newParent;
        if ((this.uvLock == null || this.uvLock != value) && (newParent = this.getVanillaParent().uvlock(value)) != this.getVanillaParent()) {
            IModel ret = this.deepCopyOrMissing(newParent, null, null);
            if (ret instanceof CustomTextureModel) {
                ((CustomTextureModel)ret).uvLock = value;
            }
            return ret;
        }
        return this;
    }

    @Nonnull
    public IModel retexture(@Nonnull ImmutableMap<String, String> textures) {
        try {
            CustomTextureModel ret = this.deepCopy(this.getVanillaParent().retexture(textures), null, null);
            ret.modelInfo.field_178318_c.putAll(textures);
            return ret;
        }
        catch (IOException e) {
            GTLog.logger.error("Could not create CustomTextureModel texture deep copy", (Throwable)e);
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    @Nonnull
    public Optional<ModelBlock> asVanillaModel() {
        return Optional.ofNullable(_asVanillaModel).map(mh -> {
            try {
                return mh.invokeExact(this.getVanillaParent());
            }
            catch (Throwable e1) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).orElse(Optional.ofNullable(this.modelInfo));
    }

    private IModel deepCopyOrMissing(IModel newParent, Boolean ao, Boolean gui3d) {
        try {
            return this.deepCopy(newParent, ao, gui3d);
        }
        catch (IOException e) {
            GTLog.logger.error("Could not create texture deep copy", (Throwable)e);
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    private CustomTextureModel deepCopy(IModel newParent, Boolean ao, Boolean gui3d) throws IOException {
        ArrayList<BlockPart> parts = new ArrayList<BlockPart>();
        for (BlockPart part : this.modelInfo.func_178298_a()) {
            parts.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
        }
        ModelBlock newModel = new ModelBlock(this.modelInfo.func_178305_e(), parts, (Map)Maps.newHashMap((Map)this.modelInfo.field_178318_c), ao == null ? this.modelInfo.func_178309_b() : ao.booleanValue(), gui3d == null ? this.modelInfo.func_178311_c() : gui3d.booleanValue(), this.modelInfo.func_181682_g(), (List)Lists.newArrayList((Iterable)this.modelInfo.func_187966_f()));
        newModel.field_178317_b = this.modelInfo.field_178317_b;
        newModel.field_178315_d = this.modelInfo.field_178315_d;
        return new CustomTextureModel(newModel, newParent);
    }

    static {
        MethodHandle mh;
        try {
            mh = MethodHandles.lookup().unreflect(IModel.class.getMethod("asVanillaModel", new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            mh = null;
        }
        _asVanillaModel = mh;
    }
}

