/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.customtexture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import gregtech.api.util.GTLog;
import gregtech.asm.hooks.BlockHooks;
import gregtech.asm.hooks.CTMHooks;
import gregtech.client.model.customtexture.CustomTexture;
import gregtech.client.model.customtexture.CustomTextureModel;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class CustomTextureBakedModel
implements IBakedModel {
    private final CustomTextureModel model;
    private final IBakedModel parent;
    public static final Cache<State, CustomTextureBakedModel> MODEL_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    protected final ListMultimap<BlockRenderLayer, BakedQuad> genQuads = MultimapBuilder.enumKeys(BlockRenderLayer.class).arrayListValues().build();
    protected final Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> faceQuads = Tables.newCustomTable((Map)Maps.newEnumMap(BlockRenderLayer.class), () -> Maps.newEnumMap(EnumFacing.class));
    private final EnumMap<EnumFacing, ImmutableList<BakedQuad>> noLayerCache = new EnumMap(EnumFacing.class);
    private ImmutableList<BakedQuad> noSideNoLayerCache;

    public CustomTextureBakedModel(CustomTextureModel model, IBakedModel parent) {
        this.model = model;
        this.parent = parent;
    }

    public IBakedModel getParent(long rand) {
        if (this.parent instanceof WeightedBakedModel) {
            return ((WeightedBakedModel)this.parent).func_188627_a(rand);
        }
        return this.parent;
    }

    public CustomTextureModel getModel() {
        return this.model;
    }

    protected CustomTexture getTexture(long rand, String iconName) {
        CustomTexture ret = this.getModel().getTexture(iconName);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, iconName));
        }
        return ret;
    }

    protected TextureAtlasSprite getOverrideSprite(long rand, int tintIndex) {
        return this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
    }

    private <T> T applyToParent(long rand, Function<CustomTextureBakedModel, T> func) {
        IBakedModel parent = this.getParent(rand);
        if (parent instanceof CustomTextureBakedModel) {
            return func.apply((CustomTextureBakedModel)parent);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected CustomTextureBakedModel createModel(@Nullable IBlockState state, CustomTextureModel model, long rand) {
        IBakedModel parent = this.getParent(rand);
        while (parent instanceof CustomTextureBakedModel) {
            parent = ((CustomTextureBakedModel)parent).getParent(rand);
        }
        CustomTextureBakedModel ret = new CustomTextureBakedModel(model, parent);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                LinkedList<BakedQuad> quads;
                List parentQuads = parent.func_188616_a(state, facing, rand);
                if (facing != null) {
                    quads = new LinkedList<BakedQuad>();
                    ret.faceQuads.put((Object)layer, (Object)facing, quads);
                } else {
                    quads = ret.genQuads.get((Object)layer);
                }
                LinkedHashMap<void, CustomTexture> textureMap = new LinkedHashMap<void, CustomTexture>();
                for (BakedQuad bakedQuad : parentQuads) {
                    void var19_21;
                    CustomTexture tex = this.getTexture(rand, bakedQuad.func_187508_a().func_94215_i());
                    if (tex == null) continue;
                    TextureAtlasSprite spriteReplacement = this.getOverrideSprite(rand, bakedQuad.func_178211_c());
                    if (spriteReplacement != null) {
                        BakedQuadRetextured bakedQuadRetextured = new BakedQuadRetextured(bakedQuad, spriteReplacement);
                    }
                    textureMap.put(var19_21, tex);
                }
                BlockHooks.ENABLE = false;
                for (Map.Entry entry : textureMap.entrySet()) {
                    if (((CustomTexture)entry.getValue()).getLayer() != layer && (((CustomTexture)entry.getValue()).getLayer() != null || state != null && !state.func_177230_c().canRenderInLayer(state, layer))) continue;
                    quads.add(((CustomTexture)entry.getValue()).transformQuad((BakedQuad)entry.getKey()));
                }
                BlockHooks.ENABLE = true;
            }
        }
        return ret;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        IBakedModel parent = this.getParent(rand);
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        try {
            ImmutableList<BakedQuad> ret;
            CustomTextureBakedModel baked = (CustomTextureBakedModel)MODEL_CACHE.get((Object)new State(state, parent), () -> this.createModel(state, this.model, rand));
            if (side != null && layer != null) {
                ret = (List)baked.faceQuads.get((Object)layer, (Object)side);
            } else if (side != null) {
                ret = (List)baked.noLayerCache.computeIfAbsent(side, f -> ImmutableList.copyOf((Collection)baked.faceQuads.column(f).values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList())));
            } else if (layer != null) {
                ret = baked.genQuads.get((Object)layer);
            } else {
                ret = baked.noSideNoLayerCache;
                if (ret == null) {
                    ret = baked.noSideNoLayerCache = ImmutableList.copyOf((Collection)baked.genQuads.values().stream().distinct().collect(Collectors.toList()));
                }
            }
            return CTMHooks.getQuadsWithOptiFine(ret, layer, this, state, side, rand);
        }
        catch (ExecutionException e) {
            GTLog.logger.error("Could not retrieve BakedModel from cache", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return this.parent.handlePerspective(cameraTransformType);
    }

    private static class State {
        private final IBlockState cleanState;
        private final IBakedModel parent;

        public State(IBlockState cleanState, IBakedModel parent) {
            this.cleanState = cleanState;
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            return this.parent == other.parent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }
    }
}

