/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.customtexture;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import gregtech.client.model.customtexture.MetadataSectionCTM;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class CustomTexture {
    private final MetadataSectionCTM meta;

    public CustomTexture(MetadataSectionCTM meta) {
        this.meta = meta;
    }

    public BlockRenderLayer getLayer() {
        return this.meta == null ? null : this.meta.layer;
    }

    public BakedQuad transformQuad(BakedQuad quad) {
        if (this.meta == null) {
            return quad;
        }
        return CustomTexture.rebake(this.meta.blockLight, this.meta.skyLight, quad);
    }

    public static BakedQuad rebake(int blockLight, int skyLight, BakedQuad quad) {
        boolean hasLightmap;
        Builder builder = new Builder(quad.getFormat(), quad.func_187508_a());
        quad.pipe((IVertexConsumer)builder);
        VertexFormat format = builder.vertexFormat;
        boolean bl = hasLightmap = (blockLight > 0 || skyLight > 0) && !FMLClientHandler.instance().hasOptifine();
        if (hasLightmap) {
            if (format == DefaultVertexFormats.field_176599_b) {
                format = DefaultVertexFormats.field_176600_a;
            } else if (!format.func_177343_g().contains(DefaultVertexFormats.field_181716_p)) {
                format = new VertexFormat(format).func_181721_a(DefaultVertexFormats.field_181716_p);
            }
        }
        UnpackedBakedQuad.Builder unpackedBuilder = new UnpackedBakedQuad.Builder(format);
        unpackedBuilder.setQuadOrientation(builder.quadOrientation);
        unpackedBuilder.setQuadTint(builder.quadTint);
        unpackedBuilder.setApplyDiffuseLighting(builder.applyDiffuseLighting);
        unpackedBuilder.setTexture(builder.sprite);
        Vector2f[] uvs = builder.uvs();
        for (int v = 0; v < 4; ++v) {
            for (int i = 0; i < format.func_177345_h(); ++i) {
                VertexFormatElement ele = format.func_177348_c(i);
                if (ele.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                    unpackedBuilder.put(i, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue;
                }
                if (ele.func_177375_c() == VertexFormatElement.EnumUsage.UV) {
                    if (ele.func_177369_e() == 1) {
                        unpackedBuilder.put(i, new float[]{(float)blockLight * 32.0f / 65535.0f, (float)skyLight * 32.0f / 65535.0f});
                        continue;
                    }
                    if (ele.func_177369_e() != 0) continue;
                    Vector2f uv = uvs[v];
                    unpackedBuilder.put(i, new float[]{uv.x, uv.y, 0.0f, 1.0f});
                    continue;
                }
                unpackedBuilder.put(i, (float[])builder.data.get((Object)ele.func_177375_c()).get(v));
            }
        }
        return unpackedBuilder.build();
    }

    public static class Builder
    implements IVertexConsumer {
        public final VertexFormat vertexFormat;
        public final TextureAtlasSprite sprite;
        public int quadTint = -1;
        public EnumFacing quadOrientation;
        public boolean applyDiffuseLighting;
        public final ListMultimap<VertexFormatElement.EnumUsage, float[]> data = MultimapBuilder.enumKeys(VertexFormatElement.EnumUsage.class).arrayListValues().build();

        public Builder(VertexFormat vertexFormat, TextureAtlasSprite sprite) {
            this.vertexFormat = vertexFormat;
            this.sprite = sprite;
        }

        public void put(int element, float ... data) {
            if (data == null) {
                return;
            }
            float[] copy = new float[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            VertexFormatElement ele = this.vertexFormat.func_177348_c(element);
            this.data.put((Object)ele.func_177375_c(), (Object)copy);
        }

        public Vector3f[] verts() {
            return (Vector3f[])this.fromData(this.data.get((Object)VertexFormatElement.EnumUsage.POSITION), 3);
        }

        public Vector2f[] uvs() {
            return (Vector2f[])this.fromData(this.data.get((Object)VertexFormatElement.EnumUsage.UV), 2);
        }

        private <T extends Vector> T[] fromData(List<float[]> data, int size) {
            Vector2f[] ret = size == 2 ? new Vector2f[data.size()] : new Vector3f[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                ret[i] = size == 2 ? new Vector2f(data.get(i)[0], data.get(i)[1]) : new Vector3f(data.get(i)[0], data.get(i)[1], data.get(i)[2]);
            }
            return (Vector[])ret;
        }

        public VertexFormat getVertexFormat() {
            return this.vertexFormat;
        }

        public void setQuadTint(int tint) {
            this.quadTint = tint;
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.quadOrientation = orientation;
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        public void setTexture(@Nullable TextureAtlasSprite texture) {
        }
    }
}

