/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.generator;

import com.google.common.collect.ImmutableSet;
import gregtech.api.worldgen.generator.CachedGridEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.worldgen.WorldGenRubberTree;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGeneratorImpl
implements IWorldGenerator {
    public static final WorldGeneratorImpl INSTANCE = new WorldGeneratorImpl();
    private static final Set<OreGenEvent.GenerateMinable.EventType> ORE_EVENT_TYPES = ImmutableSet.of((Object)OreGenEvent.GenerateMinable.EventType.COAL, (Object)OreGenEvent.GenerateMinable.EventType.DIAMOND, (Object)OreGenEvent.GenerateMinable.EventType.GOLD, (Object)OreGenEvent.GenerateMinable.EventType.IRON, (Object)OreGenEvent.GenerateMinable.EventType.LAPIS, (Object)OreGenEvent.GenerateMinable.EventType.REDSTONE, (Object[])new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.QUARTZ, OreGenEvent.GenerateMinable.EventType.EMERALD});
    public static final int GRID_SIZE_X = 3;
    public static final int GRID_SIZE_Z = 3;

    private WorldGeneratorImpl() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        OreGenEvent.GenerateMinable.EventType eventType = event.getType();
        if (ConfigHolder.worldgen.disableVanillaOres && ORE_EVENT_TYPES.contains(eventType)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int selfGridX = Math.floorDiv(chunkX, 3);
        int selfGridZ = Math.floorDiv(chunkZ, 3);
        this.generateInternal(world, selfGridX, selfGridZ, chunkX, chunkZ, random);
        long rubberTreeSeed = random.nextLong();
        if (!ConfigHolder.worldgen.disableRubberTreeGeneration) {
            WorldGeneratorImpl.generateRubberTree(random, rubberTreeSeed, chunkProvider.func_186025_d(chunkX, chunkZ), ConfigHolder.worldgen.rubberTreeRateIncrease);
        }
    }

    private void generateInternal(World world, int selfGridX, int selfGridZ, int chunkX, int chunkZ, Random random) {
        int halfSizeX = 1;
        int halfSizeZ = 1;
        for (int gridX = -halfSizeX; gridX <= halfSizeX; ++gridX) {
            for (int gridZ = -halfSizeZ; gridZ <= halfSizeZ; ++gridZ) {
                CachedGridEntry cachedGridEntry = CachedGridEntry.getOrCreateEntry(world, selfGridX + gridX, selfGridZ + gridZ, chunkX, chunkZ);
                cachedGridEntry.populateChunk(world, chunkX, chunkZ, random);
            }
        }
    }

    private static void generateRubberTree(Random random, long seed, Chunk chunk, double baseScale) {
        random.setSeed(seed);
        Biome[] biomes = new Biome[4];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int seaLevel = chunk.func_177412_p().func_181545_F();
        for (int i = 0; i < 4; ++i) {
            int x = chunk.field_76635_g * 16 + 8 + (i & 1) * 15;
            int z = chunk.field_76647_h * 16 + 8 + ((i & 2) >>> 1) * 15;
            biomes[i] = chunk.func_177412_p().func_72959_q().func_180300_a((BlockPos)pos.func_181079_c(x, seaLevel, z), Biomes.field_76772_c);
        }
        int rubberTrees = 0;
        for (Biome biome : biomes) {
            if (biome == null) continue;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubberTrees += random.nextInt(10) + 5;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
            rubberTrees += random.nextInt(5) + 1;
        }
        rubberTrees = (int)Math.round((double)rubberTrees * baseScale);
        if ((rubberTrees /= 2) > 0 && random.nextInt(100) < rubberTrees) {
            for (int j = 0; j < rubberTrees; ++j) {
                pos.func_181079_c(chunk.field_76635_g * 16 + random.nextInt(16), seaLevel, chunk.field_76647_h * 16 + random.nextInt(16));
                if (WorldGenRubberTree.WORLD_GEN_INSTANCE.generateImpl(chunk.func_177412_p(), random, pos)) continue;
                rubberTrees -= 3;
            }
        }
    }
}

