/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.recipes.KeySharedStack;
import gregtech.api.util.ItemStackKey;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class OverlayedItemHandler {
    private final OverlayedItemHandlerSlot[] originalSlots;
    private final OverlayedItemHandlerSlot[] slots;
    private final IItemHandler overlayedHandler;

    public OverlayedItemHandler(IItemHandler toOverlay) {
        this.slots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.originalSlots = new OverlayedItemHandlerSlot[toOverlay.getSlots()];
        this.overlayedHandler = toOverlay;
    }

    public void reset() {
        for (int i = 0; i < this.originalSlots.length; ++i) {
            if (this.originalSlots[i] == null) continue;
            this.slots[i] = this.originalSlots[i].copy();
        }
    }

    public int getSlots() {
        return this.overlayedHandler.getSlots();
    }

    private void initSlot(int slot) {
        if (this.originalSlots[slot] == null) {
            ItemStack stackToMirror = this.overlayedHandler.getStackInSlot(slot);
            int slotLimit = this.overlayedHandler.getSlotLimit(slot);
            this.originalSlots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
            this.slots[slot] = new OverlayedItemHandlerSlot(stackToMirror, slotLimit);
        }
    }

    public int insertStackedItemStackKey(ItemStackKey key, int amountToInsert) {
        int insertedAmount;
        int canInsertUpTo;
        int lastKnownPopulatedSlot = 0;
        int i = 0;
        while (i < this.slots.length) {
            this.initSlot(i);
            ItemStackKey slotKey = this.slots[i].getItemStackKey();
            if ((slotKey == key || slotKey == null) && (canInsertUpTo = this.slots[i].slotLimit - this.slots[i].count) > 0) {
                insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                this.slots[i].setItemStackKey(key);
                this.slots[i].setCount(this.slots[i].getCount() + insertedAmount);
                amountToInsert -= insertedAmount;
            }
            lastKnownPopulatedSlot = i++;
            if (amountToInsert != 0) continue;
            return 0;
        }
        if (amountToInsert > 0) {
            for (i = lastKnownPopulatedSlot + 1; i < this.slots.length; ++i) {
                OverlayedItemHandlerSlot slot = this.slots[i];
                if (slot.getItemStackKey() != null) continue;
                canInsertUpTo = Math.min(key.getMaxStackSize(), slot.slotLimit);
                if (canInsertUpTo > 0) {
                    insertedAmount = Math.min(canInsertUpTo, amountToInsert);
                    slot.setItemStackKey(key);
                    slot.setCount(insertedAmount);
                    amountToInsert -= insertedAmount;
                }
                if (amountToInsert != 0) continue;
                return 0;
            }
        }
        return amountToInsert;
    }

    private static class OverlayedItemHandlerSlot {
        private ItemStackKey itemStackKey = null;
        private int count = 0;
        private int slotLimit = 0;

        OverlayedItemHandlerSlot(ItemStack stackToMirror, int slotLimit) {
            if (!stackToMirror.func_190926_b()) {
                this.itemStackKey = KeySharedStack.getRegisteredStack(stackToMirror);
                this.count = stackToMirror.func_190916_E();
                this.slotLimit = Math.min(this.itemStackKey.getMaxStackSize(), slotLimit);
            } else {
                this.slotLimit = slotLimit;
            }
        }

        OverlayedItemHandlerSlot(ItemStackKey itemStackKey, int slotLimit, int count) {
            this.itemStackKey = itemStackKey;
            this.count = count;
            this.slotLimit = slotLimit;
        }

        public int getSlotLimit() {
            return this.slotLimit;
        }

        public int getCount() {
            return this.count;
        }

        public ItemStackKey getItemStackKey() {
            return this.itemStackKey;
        }

        public void setItemStackKey(ItemStackKey itemStackKey) {
            if (this.itemStackKey != itemStackKey) {
                this.itemStackKey = itemStackKey;
                this.slotLimit = Math.min(itemStackKey.getMaxStackSize(), this.slotLimit);
            }
        }

        public void setCount(int count) {
            this.count = count;
        }

        OverlayedItemHandlerSlot copy() {
            return new OverlayedItemHandlerSlot(this.itemStackKey, this.slotLimit, this.count);
        }
    }
}

