/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.FluidKey;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.OverlayedFluidHandler;
import gregtech.api.util.OverlayedItemHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class GTTransferUtils {
    public static int transferFluids(@Nonnull IFluidHandler sourceHandler, @Nonnull IFluidHandler destHandler) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, Integer.MAX_VALUE, fluidStack -> true);
    }

    public static int transferFluids(@Nonnull IFluidHandler sourceHandler, @Nonnull IFluidHandler destHandler, int transferLimit) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, transferLimit, fluidStack -> true);
    }

    public static int transferFluids(@Nonnull IFluidHandler sourceHandler, @Nonnull IFluidHandler destHandler, int transferLimit, @Nonnull Predicate<FluidStack> fluidFilter) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            int canInsertAmount;
            FluidStack currentFluid = tankProperties.getContents();
            if (currentFluid == null || currentFluid.amount == 0 || !fluidFilter.test(currentFluid)) continue;
            currentFluid.amount = fluidLeftToTransfer;
            FluidStack fluidStack = sourceHandler.drain(currentFluid, false);
            if (fluidStack == null || fluidStack.amount == 0 || (canInsertAmount = destHandler.fill(fluidStack, false)) <= 0) continue;
            fluidStack.amount = canInsertAmount;
            if ((fluidStack = sourceHandler.drain(fluidStack, true)) == null || fluidStack.amount <= 0) continue;
            destHandler.fill(fluidStack, true);
            if ((fluidLeftToTransfer -= fluidStack.amount) == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    public static boolean transferExactFluidStack(@Nonnull IFluidHandler sourceHandler, @Nonnull IFluidHandler destHandler, FluidStack fluidStack) {
        int amount = fluidStack.amount;
        FluidStack sourceFluid = sourceHandler.drain(fluidStack, false);
        if (sourceFluid == null || sourceFluid.amount != amount) {
            return false;
        }
        int canInsertAmount = destHandler.fill(sourceFluid, false);
        if (canInsertAmount == amount && (sourceFluid = sourceHandler.drain(sourceFluid, true)) != null && sourceFluid.amount > 0) {
            destHandler.fill(sourceFluid, true);
            return true;
        }
        return false;
    }

    public static void moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.func_190926_b()) continue;
            ItemStack remainder = GTTransferUtils.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            GTTransferUtils.insertItem(targetInventory, sourceStack, false);
        }
    }

    public static boolean addItemsToItemHandler(IItemHandler handler, boolean simulate, List<ItemStack> items) {
        if (simulate) {
            OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler(handler);
            Map<ItemStackKey, Integer> stackKeyMap = GTHashMaps.fromItemStackCollection(items);
            for (Map.Entry<ItemStackKey, Integer> entry : stackKeyMap.entrySet()) {
                int amountToInsert = entry.getValue();
                int amount = overlayedItemHandler.insertStackedItemStackKey(entry.getKey(), amountToInsert);
                if (amount <= 0) continue;
                return false;
            }
            return true;
        }
        items.forEach(stack -> GTTransferUtils.insertItem(handler, stack, false));
        return true;
    }

    public static boolean addFluidsToFluidHandler(IMultipleTankHandler fluidHandler, boolean simulate, List<FluidStack> fluidStacks) {
        if (simulate) {
            OverlayedFluidHandler overlayedFluidHandler = new OverlayedFluidHandler(fluidHandler);
            Map<FluidKey, Integer> fluidKeyMap = GTHashMaps.fromFluidCollection(fluidStacks);
            for (Map.Entry<FluidKey, Integer> entry : fluidKeyMap.entrySet()) {
                int amountToInsert = entry.getValue();
                int inserted = overlayedFluidHandler.insertStackedFluidKey(entry.getKey(), amountToInsert);
                if (inserted == amountToInsert) continue;
                return false;
            }
            return true;
        }
        fluidStacks.forEach(fluidStack -> fluidHandler.fill((FluidStack)fluidStack, true));
        return true;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return GTTransferUtils.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                emptySlots.add(i);
            }
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack insertToEmpty(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.func_190926_b()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.func_190926_b() || !(stack = handler.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean areStackable(FluidStack stack, FluidStack stack2) {
        return stack != null && stack.amount > 0 && stack2 != null && stack2.amount > 0 && stack.isFluidEqual(stack2);
    }

    public static void fillInternalTankFromFluidContainer(IFluidHandler fluidHandler, IItemHandlerModifiable itemHandler, int inputSlot, int outputSlot) {
        ItemStack inputContainerStack = itemHandler.extractItem(inputSlot, 1, true);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
        if (result.isSuccess()) {
            ItemStack remainingItem = result.getResult();
            if (ItemStack.func_77989_b((ItemStack)inputContainerStack, (ItemStack)remainingItem)) {
                return;
            }
            if (!remainingItem.func_190926_b() && !itemHandler.insertItem(outputSlot, remainingItem, true).func_190926_b()) {
                return;
            }
            FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
            itemHandler.extractItem(inputSlot, 1, false);
            itemHandler.insertItem(outputSlot, remainingItem, false);
        }
    }
}

