/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.ItemAndMetadata;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;

public class WildcardAwareHashMap<V>
extends Object2ObjectOpenHashMap<ItemAndMetadata, V> {
    public WildcardAwareHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WildcardAwareHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WildcardAwareHashMap() {
    }

    public WildcardAwareHashMap(Map<? extends ItemAndMetadata, ? extends V> m) {
        super(m);
    }

    public V get(Object key) {
        ItemAndMetadata itemStack = (ItemAndMetadata)key;
        Object resultValue = super.get(key);
        if (resultValue == null && itemStack.itemDamage != Short.MAX_VALUE) {
            ItemAndMetadata wildcardStack = new ItemAndMetadata(itemStack.item, Short.MAX_VALUE);
            resultValue = super.get((Object)wildcardStack);
        }
        return (V)resultValue;
    }

    public boolean containsKey(Object key) {
        ItemAndMetadata itemStack = (ItemAndMetadata)key;
        boolean resultValue = super.containsKey(key);
        if (!resultValue && itemStack.itemDamage != Short.MAX_VALUE) {
            ItemAndMetadata wildcardStack = new ItemAndMetadata(itemStack.item, Short.MAX_VALUE);
            resultValue = super.containsKey((Object)wildcardStack);
        }
        return resultValue;
    }

    public V getOrDefault(Object key, V defaultValue) {
        V value = this.get(key);
        return value == null ? defaultValue : value;
    }
}

