/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AnimaWidgetGroup
extends WidgetGroup {
    @SideOnly(value=Side.CLIENT)
    protected Interpolator interpolator;
    protected float scale = 1.0f;

    public AnimaWidgetGroup(Position position, Size size) {
        super(position, size);
    }

    public AnimaWidgetGroup(int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
    }

    @Override
    public void updateScreenOnFrame() {
        if (this.interpolator != null) {
            this.interpolator.func_73660_a();
        }
        super.updateScreenOnFrame();
    }

    @SideOnly(value=Side.CLIENT)
    public final void maximizeWidget(Consumer<AnimaWidgetGroup> callback) {
        this.scale = 0.0f;
        this.setVisible(true);
        this.interpolator = new Interpolator(0.0f, 1.0f, 10, Eases.EaseLinear, value -> {
            this.scale = value.floatValue();
        }, value -> {
            this.interpolator = null;
            if (callback != null) {
                callback.accept(this);
            }
        });
        this.interpolator.start();
    }

    @SideOnly(value=Side.CLIENT)
    public final void minimizeWidget(Consumer<AnimaWidgetGroup> callback) {
        this.scale = 1.0f;
        this.interpolator = new Interpolator(1.0f, 0.0f, 10, Eases.EaseLinear, value -> {
            this.scale = value.floatValue();
        }, value -> {
            this.setVisible(false);
            this.interpolator = null;
            if (callback != null) {
                callback.accept(this);
            }
        });
        this.interpolator.start();
    }

    @SideOnly(value=Side.CLIENT)
    protected void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @SideOnly(value=Side.CLIENT)
    protected void hookDrawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
    }

    @Override
    public final void drawInForeground(int mouseX, int mouseY) {
        if (this.scale == 0.0f) {
            return;
        }
        if (this.scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(((float)this.gui.getScreenWidth() - (float)this.gui.getScreenWidth() * this.scale) / 2.0f), (float)(((float)this.gui.getScreenHeight() - (float)this.gui.getScreenHeight() * this.scale) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
            this.hookDrawInForeground(0, 0);
            GlStateManager.func_179121_F();
        } else {
            this.hookDrawInForeground(mouseX, mouseY);
        }
    }

    @Override
    public final void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.scale == 0.0f) {
            return;
        }
        if (this.scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(((float)this.gui.getScreenWidth() - (float)this.gui.getScreenWidth() * this.scale) / 2.0f), (float)(((float)this.gui.getScreenHeight() - (float)this.gui.getScreenHeight() * this.scale) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
            this.hookDrawInBackground(0, 0, partialTicks, context);
            GlStateManager.func_179121_F();
        } else {
            this.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        }
    }
}

