/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.ParallelLogic;
import javax.annotation.Nonnull;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IParallelableRecipeLogic {
    default public void applyParallelBonus(@Nonnull RecipeBuilder<?> builder) {
    }

    default public RecipeBuilder<?> findMultipliedParallelRecipe(@Nonnull RecipeMap<?> recipeMap, @Nonnull Recipe currentRecipe, @Nonnull IItemHandlerModifiable inputs, @Nonnull IMultipleTankHandler fluidInputs, @Nonnull IItemHandlerModifiable outputs, @Nonnull IMultipleTankHandler fluidOutputs, int parallelLimit, long maxVoltage, @Nonnull IVoidable voidable) {
        return ParallelLogic.doParallelRecipes(currentRecipe, recipeMap, inputs, fluidInputs, outputs, fluidOutputs, parallelLimit, maxVoltage, voidable);
    }

    default public RecipeBuilder<?> findAppendedParallelItemRecipe(@Nonnull RecipeMap<?> recipeMap, @Nonnull IItemHandlerModifiable inputs, @Nonnull IItemHandlerModifiable outputs, int parallelLimit, long maxVoltage, @Nonnull IVoidable voidable) {
        return ParallelLogic.appendItemRecipes(recipeMap, inputs, outputs, parallelLimit, maxVoltage, voidable);
    }

    default public Recipe findParallelRecipe(@Nonnull AbstractRecipeLogic logic, @Nonnull Recipe currentRecipe, @Nonnull IItemHandlerModifiable inputs, @Nonnull IMultipleTankHandler fluidInputs, @Nonnull IItemHandlerModifiable outputs, @Nonnull IMultipleTankHandler fluidOutputs, long maxVoltage, int parallelLimit) {
        if (parallelLimit > 1 && logic.getRecipeMap() != null) {
            RecipeBuilder<?> parallelBuilder = null;
            if (logic.getParallelLogicType() == ParallelLogicType.MULTIPLY) {
                parallelBuilder = this.findMultipliedParallelRecipe(logic.getRecipeMap(), currentRecipe, inputs, fluidInputs, outputs, fluidOutputs, parallelLimit, maxVoltage, logic.getMetaTileEntity());
            } else if (logic.getParallelLogicType() == ParallelLogicType.APPEND_ITEMS) {
                parallelBuilder = this.findAppendedParallelItemRecipe(logic.getRecipeMap(), inputs, outputs, parallelLimit, maxVoltage, logic.getMetaTileEntity());
            }
            if (parallelBuilder == null) {
                logic.invalidateInputs();
                return null;
            }
            if (parallelBuilder.getParallel() == 0) {
                logic.invalidateOutputs();
                return null;
            }
            logic.setParallelRecipesPerformed(parallelBuilder.getParallel());
            this.applyParallelBonus(parallelBuilder);
            return parallelBuilder.build().getResult();
        }
        return currentRecipe;
    }
}

