/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.common.items.MetaItems;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class IntCircuitIngredient
extends GTRecipeItemInput {
    public static final int CIRCUIT_MAX = 32;
    private final int matchingConfigurations;

    public static IntCircuitIngredient getOrCreate(IntCircuitIngredient ri) {
        return (IntCircuitIngredient)IntCircuitIngredient.getFromCache(new IntCircuitIngredient(ri.matchingConfigurations));
    }

    @Override
    protected IntCircuitIngredient copy() {
        IntCircuitIngredient copy = new IntCircuitIngredient(this.matchingConfigurations);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    public IntCircuitIngredient(int matchingConfigurations) {
        super(IntCircuitIngredient.getIntegratedCircuit(matchingConfigurations));
        this.matchingConfigurations = matchingConfigurations;
    }

    public static ItemStack getIntegratedCircuit(int configuration) {
        ItemStack stack = MetaItems.INTEGRATED_CIRCUIT.getStackForm();
        IntCircuitIngredient.setCircuitConfiguration(stack, configuration);
        return stack;
    }

    public static void setCircuitConfiguration(ItemStack itemStack, int configuration) {
        if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack)) {
            throw new IllegalArgumentException("Given item stack is not an integrated circuit!");
        }
        if (configuration < 0 || configuration > 32) {
            throw new IllegalArgumentException("Given configuration number is out of range!");
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("Configuration", configuration);
    }

    public static int getCircuitConfiguration(ItemStack itemStack) {
        if (!IntCircuitIngredient.isIntegratedCircuit(itemStack)) {
            return 0;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound.func_74762_e("Configuration");
    }

    public static boolean isIntegratedCircuit(ItemStack itemStack) {
        boolean isCircuit = MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack);
        if (isCircuit && !itemStack.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Configuration", 0);
            itemStack.func_77982_d(compound);
        }
        return isCircuit;
    }

    public static void adjustConfiguration(PlayerInventoryHolder holder, int amount) {
        IntCircuitIngredient.adjustConfiguration(holder.getCurrentItem(), amount);
        holder.markAsDirty();
    }

    public static void adjustConfiguration(ItemStack stack, int amount) {
        if (!IntCircuitIngredient.isIntegratedCircuit(stack)) {
            return;
        }
        int configuration = IntCircuitIngredient.getCircuitConfiguration(stack);
        configuration += amount;
        configuration = MathHelper.func_76125_a((int)configuration, (int)0, (int)32);
        IntCircuitIngredient.setCircuitConfiguration(stack, configuration);
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack itemStack) {
        return itemStack != null && MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack) && this.matchingConfigurations == IntCircuitIngredient.getCircuitConfiguration(itemStack);
    }
}

