/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternStringError;
import gregtech.api.util.BlockInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TraceabilityPredicate {
    public static TraceabilityPredicate ANY = new TraceabilityPredicate(state -> true);
    public static TraceabilityPredicate AIR = new TraceabilityPredicate(blockWorldState -> blockWorldState.getBlockState().func_177230_c().isAir(blockWorldState.getBlockState(), (IBlockAccess)blockWorldState.getWorld(), blockWorldState.getPos()));
    public static Supplier<TraceabilityPredicate> HEATING_COILS = () -> new TraceabilityPredicate(blockWorldState -> {
        IBlockState blockState = blockWorldState.getBlockState();
        if (GregTechAPI.HEATING_COILS.containsKey((Object)blockState)) {
            IHeatingCoilBlockStats stats = (IHeatingCoilBlockStats)GregTechAPI.HEATING_COILS.get((Object)blockState);
            IHeatingCoilBlockStats currentCoil = blockWorldState.getMatchContext().getOrPut("CoilType", stats);
            if (!currentCoil.equals(stats)) {
                blockWorldState.setError(new PatternStringError("gregtech.multiblock.pattern.error.coils"));
                return false;
            }
            blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList()).add(blockWorldState.getPos());
            return true;
        }
        return false;
    }, () -> (BlockInfo[])GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).map(entry -> new BlockInfo((IBlockState)entry.getKey(), null)).toArray(BlockInfo[]::new)).addTooltips("gregtech.multiblock.pattern.error.coils");
    public final List<SimplePredicate> common = new ArrayList<SimplePredicate>();
    public final List<SimplePredicate> limited = new ArrayList<SimplePredicate>();
    protected boolean isCenter;
    protected boolean hasAir = false;
    protected boolean isSingle = true;

    public TraceabilityPredicate() {
    }

    public TraceabilityPredicate(TraceabilityPredicate predicate) {
        this.common.addAll(predicate.common);
        this.limited.addAll(predicate.limited);
        this.isCenter = predicate.isCenter;
        this.hasAir = predicate.hasAir;
        this.isSingle = predicate.isSingle;
    }

    public TraceabilityPredicate(Predicate<BlockWorldState> predicate, Supplier<BlockInfo[]> candidates) {
        this.common.add(new SimplePredicate(predicate, candidates));
    }

    public TraceabilityPredicate(Predicate<BlockWorldState> predicate) {
        this(predicate, null);
    }

    public boolean isHasAir() {
        return this.hasAir;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public TraceabilityPredicate setCenter() {
        this.isCenter = true;
        return this;
    }

    public TraceabilityPredicate sort() {
        this.limited.sort(Comparator.comparingInt(a -> (a.minLayerCount + 1) * 100 + a.minGlobalCount));
        return this;
    }

    public TraceabilityPredicate addTooltips(String ... tips) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && tips.length > 0) {
            List tooltips = Arrays.stream(tips).collect(Collectors.toList());
            this.common.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (((SimplePredicate)predicate).toolTips == null) {
                    ((SimplePredicate)predicate).toolTips = new ArrayList();
                }
                ((SimplePredicate)predicate).toolTips.addAll(tooltips);
            });
            this.limited.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (((SimplePredicate)predicate).toolTips == null) {
                    ((SimplePredicate)predicate).toolTips = new ArrayList();
                }
                ((SimplePredicate)predicate).toolTips.addAll(tooltips);
            });
        }
        return this;
    }

    public TraceabilityPredicate addTooltip(String langKey, Object ... data) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.addTooltips(I18n.func_135052_a((String)langKey, (Object[])data));
        }
        return this;
    }

    public TraceabilityPredicate setMinGlobalLimited(int min) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.minGlobalCount = min;
        }
        return this;
    }

    public TraceabilityPredicate setMinGlobalLimited(int min, int previewCount) {
        return this.setMinGlobalLimited(min).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMaxGlobalLimited(int max) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.maxGlobalCount = max;
        }
        return this;
    }

    public TraceabilityPredicate setMaxGlobalLimited(int max, int previewCount) {
        return this.setMaxGlobalLimited(max).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMinLayerLimited(int min) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.minLayerCount = min;
        }
        return this;
    }

    public TraceabilityPredicate setMinLayerLimited(int min, int previewCount) {
        return this.setMinLayerLimited(min).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setMaxLayerLimited(int max) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.maxLayerCount = max;
        }
        return this;
    }

    public TraceabilityPredicate setMaxLayerLimited(int max, int previewCount) {
        return this.setMaxLayerLimited(max).setPreviewCount(previewCount);
    }

    public TraceabilityPredicate setExactLimit(int limit) {
        return this.setMinGlobalLimited(limit).setMaxGlobalLimited(limit);
    }

    public TraceabilityPredicate setPreviewCount(int count) {
        this.common.forEach(predicate -> {
            predicate.previewCount = count;
        });
        this.limited.forEach(predicate -> {
            predicate.previewCount = count;
        });
        return this;
    }

    public boolean test(BlockWorldState blockWorldState) {
        boolean flag = false;
        for (SimplePredicate predicate2 : this.limited) {
            if (!predicate2.testLimited(blockWorldState)) continue;
            flag = true;
        }
        return flag || this.common.stream().anyMatch(predicate -> predicate.test(blockWorldState));
    }

    public TraceabilityPredicate or(TraceabilityPredicate other) {
        if (other != null) {
            TraceabilityPredicate newPredicate = new TraceabilityPredicate(this);
            newPredicate.isSingle = this != AIR && other != AIR ? false : this.isSingle && other.isSingle;
            newPredicate.hasAir = newPredicate.hasAir || this == AIR || other == AIR;
            newPredicate.common.addAll(other.common);
            newPredicate.limited.addAll(other.limited);
            return newPredicate;
        }
        return this;
    }

    public static class SinglePredicateError
    extends PatternError {
        public final SimplePredicate predicate;
        public final int type;

        public SinglePredicateError(SimplePredicate predicate, int type) {
            this.predicate = predicate;
            this.type = type;
        }

        @Override
        public List<List<ItemStack>> getCandidates() {
            return Collections.singletonList(this.predicate.getCandidates());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getErrorInfo() {
            int number = -1;
            if (this.type == 0) {
                number = this.predicate.maxGlobalCount;
            }
            if (this.type == 1) {
                number = this.predicate.minGlobalCount;
            }
            if (this.type == 2) {
                number = this.predicate.maxLayerCount;
            }
            if (this.type == 3) {
                number = this.predicate.minLayerCount;
            }
            return I18n.func_135052_a((String)("gregtech.multiblock.pattern.error.limited." + this.type), (Object[])new Object[]{number});
        }
    }

    public static class SimplePredicate {
        public final Supplier<BlockInfo[]> candidates;
        public final Predicate<BlockWorldState> predicate;
        @SideOnly(value=Side.CLIENT)
        private List<String> toolTips;
        public int minGlobalCount = -1;
        public int maxGlobalCount = -1;
        public int minLayerCount = -1;
        public int maxLayerCount = -1;
        public int previewCount = -1;

        public SimplePredicate(Predicate<BlockWorldState> predicate, Supplier<BlockInfo[]> candidates) {
            this.predicate = predicate;
            this.candidates = candidates;
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getToolTips(TraceabilityPredicate predicates) {
            ArrayList<String> result = new ArrayList<String>();
            if (this.toolTips != null) {
                this.toolTips.forEach(tip -> result.add(I18n.func_135052_a((String)tip, (Object[])new Object[0])));
            }
            if (this.minGlobalCount == this.maxGlobalCount && this.maxGlobalCount != -1) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited_exact", (Object[])new Object[]{this.minGlobalCount}));
            } else if (this.minGlobalCount != this.maxGlobalCount && this.minGlobalCount != -1 && this.maxGlobalCount != -1) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited_within", (Object[])new Object[]{this.minGlobalCount, this.maxGlobalCount}));
            } else {
                if (this.minGlobalCount != -1) {
                    result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited.1", (Object[])new Object[]{this.minGlobalCount}));
                }
                if (this.maxGlobalCount != -1) {
                    result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited.0", (Object[])new Object[]{this.maxGlobalCount}));
                }
            }
            if (this.minLayerCount != -1) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited.3", (Object[])new Object[]{this.minLayerCount}));
            }
            if (this.maxLayerCount != -1) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.error.limited.2", (Object[])new Object[]{this.maxLayerCount}));
            }
            if (predicates == null) {
                return result;
            }
            if (predicates.isSingle) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.single", (Object[])new Object[0]));
            }
            if (predicates.hasAir) {
                result.add(I18n.func_135052_a((String)"gregtech.multiblock.pattern.replaceable_air", (Object[])new Object[0]));
            }
            return result;
        }

        public boolean test(BlockWorldState blockWorldState) {
            return this.predicate.test(blockWorldState);
        }

        public boolean testLimited(BlockWorldState blockWorldState) {
            return this.testGlobal(blockWorldState) && this.testLayer(blockWorldState);
        }

        public boolean testGlobal(BlockWorldState blockWorldState) {
            if (this.minGlobalCount == -1 && this.maxGlobalCount == -1) {
                return true;
            }
            Integer count = blockWorldState.globalCount.get(this);
            boolean base = this.predicate.test(blockWorldState);
            count = (count == null ? 0 : count) + (base ? 1 : 0);
            blockWorldState.globalCount.put(this, count);
            if (this.maxGlobalCount == -1 || count <= this.maxGlobalCount) {
                return base;
            }
            blockWorldState.setError(new SinglePredicateError(this, 0));
            return false;
        }

        public boolean testLayer(BlockWorldState blockWorldState) {
            if (this.minLayerCount == -1 && this.maxLayerCount == -1) {
                return true;
            }
            Integer count = blockWorldState.layerCount.get(this);
            boolean base = this.predicate.test(blockWorldState);
            count = (count == null ? 0 : count) + (base ? 1 : 0);
            blockWorldState.layerCount.put(this, count);
            if (this.maxLayerCount == -1 || count <= this.maxLayerCount) {
                return base;
            }
            blockWorldState.setError(new SinglePredicateError(this, 2));
            return false;
        }

        public List<ItemStack> getCandidates() {
            return this.candidates == null ? Collections.emptyList() : Arrays.stream((Object[])this.candidates.get()).filter(info -> info.getBlockState().func_177230_c() != Blocks.field_150350_a).map(info -> {
                MetaTileEntity metaTileEntity;
                IBlockState blockState = info.getBlockState();
                MetaTileEntity metaTileEntity2 = metaTileEntity = info.getTileEntity() instanceof IGregTechTileEntity ? ((IGregTechTileEntity)info.getTileEntity()).getMetaTileEntity() : null;
                if (metaTileEntity != null) {
                    return metaTileEntity.getStackForm();
                }
                return new ItemStack(Item.func_150898_a((Block)blockState.func_177230_c()), 1, blockState.func_177230_c().func_180651_a(blockState));
            }).collect(Collectors.toList());
        }
    }
}

