/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public abstract class FuelMultiblockController
extends RecipeMapMultiblockController {
    public FuelMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier) {
        super(metaTileEntityId, recipeMap);
        this.recipeMapWorkable = new MultiblockFuelRecipeLogic(this);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    protected void initializeAbilities() {
        super.initializeAbilities();
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (!this.isStructureFormed()) {
            TextComponentTranslation tooltip = new TextComponentTranslation("gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
            tooltip.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            textList.add(new TextComponentTranslation("gregtech.multiblock.invalid_structure", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip))));
        } else {
            IEnergyContainer energyContainer;
            if (ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics()) {
                this.addMaintenanceText(textList);
            }
            if (this.hasMufflerMechanics() && !this.isMufflerFaceFree()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.universal.muffler_obstructed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("gregtech.multiblock.universal.muffler_obstructed.tooltip", new Object[0])))));
            }
            if ((energyContainer = this.recipeMapWorkable.getEnergyContainer()) != null && energyContainer.getEnergyCapacity() > 0L) {
                long maxVoltage = Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
                String voltageName = GTValues.VN[GTUtility.getFloorTierByVoltage(maxVoltage)];
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.max_energy_per_tick", new Object[]{maxVoltage, voltageName}));
            }
            if (!this.recipeMapWorkable.isWorkingEnabled()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
            } else if (this.recipeMapWorkable.isActive()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.running", new Object[0]));
                int currentProgress = (int)(this.recipeMapWorkable.getProgressPercent() * 100.0);
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
            } else {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.idling", new Object[0]));
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (this.recipeMapWorkable.getMaxProgress() > 0) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_progress", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.recipeMapWorkable.getProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(this.recipeMapWorkable.getMaxProgress() / 20), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        }
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.energy_container_storage", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.energyContainer.getEnergyStored()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(this.energyContainer.getEnergyCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        if (this.recipeMapWorkable.getRecipeEUt() < 0) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.workable_production", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.recipeMapWorkable.getRecipeEUt() * -1), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTUtility.formatNumbers(this.recipeMapWorkable.getRecipeEUt() == 0 ? 0L : 1L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        }
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.multiblock_energy_output", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.energyContainer.getOutputVoltage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(GTValues.VN[GTUtility.getTierByVoltage(this.energyContainer.getOutputVoltage())], new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        if (ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics()) {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.multiblock_maintenance", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.getNumMaintenanceProblems()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        }
        return list;
    }
}

