/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.block.BlockStateTileEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;

public abstract class SyncedTileEntityBase
extends BlockStateTileEntity {
    protected final Int2ObjectMap<byte[]> updates = new Int2ObjectArrayMap(5);

    public abstract void writeInitialSyncData(PacketBuffer var1);

    public abstract void receiveInitialSyncData(PacketBuffer var1);

    public abstract void receiveCustomData(int var1, PacketBuffer var2);

    public void writeCustomData(int discriminator, Consumer<PacketBuffer> dataWriter) {
        ByteBuf backedBuffer = Unpooled.buffer();
        dataWriter.accept(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        this.updates.put(discriminator, (Object)updateData);
        IBlockState blockState = this.func_145838_q().func_176203_a(this.func_145832_p());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 0);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.updates.isEmpty()) {
            return null;
        }
        NBTTagCompound updateTag = new NBTTagCompound();
        NBTTagList listTag = new NBTTagList();
        for (Int2ObjectMap.Entry entry : this.updates.int2ObjectEntrySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74773_a(Integer.toString(entry.getIntKey()), (byte[])entry.getValue());
            listTag.func_74742_a((NBTBase)entryTag);
        }
        updateTag.func_74782_a("d", (NBTBase)listTag);
        this.updates.clear();
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTag = pkt.func_148857_g();
        NBTTagList listTag = updateTag.func_150295_c("d", 10);
        for (NBTBase entryBase : listTag) {
            NBTTagCompound entryTag = (NBTTagCompound)entryBase;
            for (String discriminatorKey : entryTag.func_150296_c()) {
                ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])entryTag.func_74770_j(discriminatorKey));
                this.receiveCustomData(Integer.parseInt(discriminatorKey), new PacketBuffer(backedBuffer));
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        ByteBuf backedBuffer = Unpooled.buffer();
        this.writeInitialSyncData(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        updateTag.func_74773_a("d", updateData);
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        byte[] updateData = tag.func_74770_j("d");
        ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
        this.receiveInitialSyncData(new PacketBuffer(backedBuffer));
    }
}

