/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SteamMetaTileEntity
extends MetaTileEntity {
    protected static final int STEAM_CAPACITY = 16000;
    protected final boolean isHighPressure;
    protected final ICubeRenderer renderer;
    protected RecipeLogicSteam workableHandler;
    protected FluidTank steamFluidTank;

    public SteamMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, boolean isHighPressure) {
        super(metaTileEntityId);
        this.workableHandler = new RecipeLogicSteam(this, recipeMap, isHighPressure, (IFluidTank)this.steamFluidTank, 1.0);
        this.isHighPressure = isHighPressure;
        this.renderer = renderer;
    }

    @Override
    public boolean isActive() {
        return this.workableHandler.isActive() && this.workableHandler.isWorkingEnabled();
    }

    @SideOnly(value=Side.CLIENT)
    protected SimpleSidedCubeRenderer getBaseRenderer() {
        if (this.isHighPressure) {
            if (this.isBrickedCasing()) {
                return Textures.STEAM_BRICKED_CASING_STEEL;
            }
            return Textures.STEAM_CASING_STEEL;
        }
        if (this.isBrickedCasing()) {
            return Textures.STEAM_BRICKED_CASING_BRONZE;
        }
        return Textures.STEAM_CASING_BRONZE;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            EnumFacing currentVentingSide = this.workableHandler.getVentingSide();
            if (currentVentingSide == facing || this.getFrontFacing() == facing) {
                return false;
            }
            this.workableHandler.setVentingSide(facing);
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseRenderer().getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
        this.renderer.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.workableHandler.isActive(), this.workableHandler.isWorkingEnabled());
        Textures.STEAM_VENT_OVERLAY.renderSided(this.workableHandler.getVentingSide(), renderState, RenderUtil.adjustTrans(translation, this.workableHandler.getVentingSide(), 2), pipeline);
    }

    protected boolean isBrickedCasing() {
        return false;
    }

    @Override
    public FluidTankList createImportFluidHandler() {
        this.steamFluidTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isSteam);
        return new FluidTankList(false, new IFluidTank[]{this.steamFluidTank});
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        return ModularUI.builder(GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure), 176, 166).label(6, 6, this.getMetaFullName()).shouldColor(false).widget(new ImageWidget(79, 42, 18, 18, GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(() -> this.workableHandler.isHasNotEnoughEnergy())).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT_STEAM.get(this.isHighPressure), 0);
    }

    @Override
    public SoundEvent getSound() {
        return this.workableHandler.getRecipeMap().getSound();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.func_177958_n() + 0.5f;
            float z = (float)pos.func_177952_p() + 0.5f;
            EnumFacing facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            float y = (float)pos.func_177956_o() + GTValues.RNG.nextFloat() * 0.375f;
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                x = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                z = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getWorld().func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            this.randomDisplayTick(x, y, z, EnumParticleTypes.FLAME, this.isHighPressure ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void randomDisplayTick(float x, float y, float z, EnumParticleTypes flame, EnumParticleTypes smoke) {
        this.getWorld().func_175688_a(smoke, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        this.getWorld().func_175688_a(flame, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

