/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import com.google.common.base.Preconditions;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.gui.IUIHolder;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TickableTileEntityBase;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.GTNameTagParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.core.network.packets.PacketRecoverMTE;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2", striprefs=true), @Optional.Interface(iface="appeng.me.helpers.IGridProxyable", modid="appliedenergistics2", striprefs=true)})
public class MetaTileEntityHolder
extends TickableTileEntityBase
implements IGregTechTileEntity,
IUIHolder,
IWorldNameable,
IActionHost,
IGridProxyable {
    MetaTileEntity metaTileEntity;
    private boolean needToUpdateLightning = false;
    private String customName;
    @SideOnly(value=Side.CLIENT)
    private GTNameTagParticle nameTagParticle;
    private final int[] timeStatistics = new int[20];
    private int timeStatisticsIndex = 0;
    private int lagWarningCount = 0;
    protected static final DecimalFormat tricorderFormat = new DecimalFormat("#.#########");

    @Override
    public MetaTileEntity getMetaTileEntity() {
        return this.metaTileEntity;
    }

    @Override
    public MetaTileEntity setMetaTileEntity(MetaTileEntity sampleMetaTileEntity) {
        Preconditions.checkNotNull((Object)sampleMetaTileEntity, (Object)"metaTileEntity");
        this.setRawMetaTileEntity(sampleMetaTileEntity.createMetaTileEntity(this));
        this.metaTileEntity.onAttached(new Object[0]);
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.updateBlockOpacity();
            this.writeCustomData(-1, buffer -> {
                buffer.func_150787_b(GregTechAPI.MTE_REGISTRY.getIdByObjectName(this.getMetaTileEntity().metaTileEntityId));
                this.getMetaTileEntity().writeInitialSyncData((PacketBuffer)buffer);
            });
            this.needToUpdateLightning = true;
            this.field_145850_b.func_190524_a(this.func_174877_v(), this.func_145838_q(), this.func_174877_v());
            this.func_70296_d();
        }
        return this.metaTileEntity;
    }

    protected void setRawMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.metaTileEntity = metaTileEntity;
        this.metaTileEntity.holder = this;
    }

    private void updateBlockOpacity() {
        IBlockState currentState = this.field_145850_b.func_180495_p(this.func_174877_v());
        boolean isMetaTileEntityOpaque = this.metaTileEntity.isOpaqueCube();
        if ((Boolean)currentState.func_177229_b((IProperty)BlockMachine.OPAQUE) != isMetaTileEntityOpaque) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), currentState.func_177226_a((IProperty)BlockMachine.OPAQUE, (Comparable)Boolean.valueOf(isMetaTileEntityOpaque)));
        }
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.customName = compound.func_74779_i("CustomName");
        if (compound.func_150297_b("MetaId", 8)) {
            String metaTileEntityIdRaw = compound.func_74779_i("MetaId");
            ResourceLocation metaTileEntityId = new ResourceLocation(metaTileEntityIdRaw);
            MetaTileEntity sampleMetaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(metaTileEntityId);
            NBTTagCompound metaTileEntityData = compound.func_74775_l("MetaTileEntity");
            if (sampleMetaTileEntity != null) {
                this.setRawMetaTileEntity(sampleMetaTileEntity.createMetaTileEntity(this));
                this.metaTileEntity.readFromNBT(metaTileEntityData);
                this.metaTileEntity.onAttached(new Object[0]);
            } else {
                GTLog.logger.error("Failed to load MetaTileEntity with invalid ID " + metaTileEntityIdRaw);
            }
            if (Loader.isModLoaded((String)"appliedenergistics2")) {
                this.readFromNBT_AENetwork(compound);
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("CustomName", this.func_70005_c_());
        if (this.metaTileEntity != null) {
            compound.func_74778_a("MetaId", this.metaTileEntity.metaTileEntityId.toString());
            NBTTagCompound metaTileEntityData = new NBTTagCompound();
            this.metaTileEntity.writeToNBT(metaTileEntityData);
            compound.func_74782_a("MetaTileEntity", (NBTBase)metaTileEntityData);
            if (Loader.isModLoaded((String)"appliedenergistics2")) {
                this.writeToNBT_AENetwork(compound);
            }
        }
        return compound;
    }

    public void func_145843_s() {
        if (this.metaTileEntity != null) {
            this.metaTileEntity.invalidate();
        }
        super.func_145843_s();
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.invalidateAE();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        Object metaTileEntityValue = this.metaTileEntity == null ? null : this.metaTileEntity.getCoverCapability(capability, facing);
        return metaTileEntityValue != null || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object metaTileEntityValue = this.metaTileEntity == null ? null : (Object)this.metaTileEntity.getCoverCapability(capability, facing);
        return (T)(metaTileEntityValue != null ? metaTileEntityValue : super.getCapability(capability, facing));
    }

    @Override
    public void func_73660_a() {
        long tickTime = System.nanoTime();
        if (this.metaTileEntity != null) {
            this.metaTileEntity.update();
        } else if (this.field_145850_b.field_72995_K) {
            GregTechAPI.networkHandler.sendToServer(new PacketRecoverMTE(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v()));
        } else if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMachine) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (this.needToUpdateLightning) {
            this.func_145831_w().func_175664_x(this.func_174877_v());
            this.needToUpdateLightning = false;
        }
        if (!this.field_145850_b.field_72995_K && this.metaTileEntity != null && this.getMetaTileEntity().isValid()) {
            tickTime = System.nanoTime() - tickTime;
            if (this.timeStatistics.length > 0) {
                this.timeStatistics[this.timeStatisticsIndex] = (int)tickTime;
                this.timeStatisticsIndex = (this.timeStatisticsIndex + 1) % this.timeStatistics.length;
            }
            if (tickTime > 100000000L && this.getMetaTileEntity().doTickProfileMessage() && this.lagWarningCount++ < 10) {
                GTLog.logger.warn("WARNING: Possible Lag Source at [" + this.func_174877_v().func_177958_n() + ", " + this.func_174877_v().func_177956_o() + ", " + this.func_174877_v().func_177952_p() + "] in Dimension " + this.field_145850_b.field_73011_w.getDimension() + " with " + tickTime + "ns caused by an instance of " + this.getMetaTileEntity().getClass());
            }
        }
        super.func_73660_a();
    }

    public ArrayList<ITextComponent> getDebugInfo(EntityPlayer player, int logLevel) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (logLevel > 2) {
            if (this.isValid()) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_machine", new Object[]{new TextComponentTranslation(this.getMetaTileEntity().metaTileEntityId.toString(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation("behavior.tricorder.debug_machine_valid", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))}));
            } else if (this.metaTileEntity == null) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_machine", new Object[]{new TextComponentTranslation("-1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation("behavior.tricorder.debug_machine_invalid_null", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            } else {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_machine", new Object[]{new TextComponentTranslation(this.getMetaTileEntity().metaTileEntityId.toString(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation("behavior.tricorder.debug_machine_invalid", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            }
        }
        if (logLevel > 1) {
            if (this.timeStatistics.length > 0) {
                double averageTickTime = 0.0;
                double worstTickTime = 0.0;
                for (int tickTime : this.timeStatistics) {
                    averageTickTime += (double)tickTime;
                    if (!((double)tickTime > worstTickTime)) continue;
                    worstTickTime = tickTime;
                }
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_cpu_load", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(averageTickTime / (double)this.timeStatistics.length), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(GTUtility.formatNumbers(this.timeStatistics.length), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(worstTickTime), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_cpu_load_seconds", new Object[]{tricorderFormat.format(worstTickTime / 1.0E9)}));
            }
            if (this.lagWarningCount > 0) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.debug_lag_count", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.lagWarningCount), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTUtility.formatNumbers(100000000L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
            }
        }
        return list;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        buf.func_180714_a(this.func_70005_c_());
        if (this.metaTileEntity != null) {
            buf.writeBoolean(true);
            buf.func_150787_b(GregTechAPI.MTE_REGISTRY.getIdByObjectName(this.metaTileEntity.metaTileEntityId));
            this.metaTileEntity.writeInitialSyncData(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.setCustomName(buf.func_150789_c(Short.MAX_VALUE));
        if (buf.readBoolean()) {
            this.receiveMTEInitializationData(buf);
        }
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buffer) {
        if (discriminator == -1) {
            this.receiveMTEInitializationData(buffer);
        } else if (this.metaTileEntity != null) {
            this.metaTileEntity.receiveCustomData(discriminator, buffer);
        }
    }

    private void receiveMTEInitializationData(@Nonnull PacketBuffer buf) {
        int metaTileEntityId = buf.func_150792_a();
        this.setMetaTileEntity(GregTechAPI.MTE_REGISTRY.getObjectById(metaTileEntityId));
        this.metaTileEntity.onPlacement();
        this.metaTileEntity.receiveInitialSyncData(buf);
        this.scheduleRenderUpdate();
        this.needToUpdateLightning = true;
    }

    @Override
    public boolean isValid() {
        return !super.func_145837_r() && this.metaTileEntity != null;
    }

    @Override
    public boolean isRemote() {
        return this.func_145831_w().field_72995_K;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos pos() {
        return this.func_174877_v();
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    public void onLoad() {
        super.onLoad();
        if (this.metaTileEntity != null) {
            this.metaTileEntity.onLoad();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.metaTileEntity != null) {
            this.metaTileEntity.onUnload();
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.onChunkUnloadAE();
        }
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_189667_a(@Nonnull Rotation rotationIn) {
        if (this.metaTileEntity != null) {
            this.metaTileEntity.setFrontFacing(rotationIn.func_185831_a(this.metaTileEntity.getFrontFacing()));
        }
    }

    public void func_189668_a(@Nonnull Mirror mirrorIn) {
        if (this.metaTileEntity != null) {
            this.func_189667_a(mirrorIn.func_185800_a(this.metaTileEntity.getFrontFacing()));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.metaTileEntity == null) {
            return false;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior cover = this.metaTileEntity.getCoverAtSide(side);
            if (!(cover instanceof IFastRenderMetaTileEntity) || !((IFastRenderMetaTileEntity)((Object)cover)).shouldRenderInPass(pass)) continue;
            return true;
        }
        if (this.metaTileEntity instanceof IFastRenderMetaTileEntity) {
            return ((IFastRenderMetaTileEntity)((Object)this.metaTileEntity)).shouldRenderInPass(pass);
        }
        return false;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.metaTileEntity instanceof IFastRenderMetaTileEntity) {
            return ((IFastRenderMetaTileEntity)((Object)this.metaTileEntity)).getRenderBoundingBox();
        }
        return new AxisAlignedBB(this.func_174877_v());
    }

    public boolean canRenderBreaking() {
        return false;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasTESR() {
        if (this.metaTileEntity == null) {
            return false;
        }
        if (this.metaTileEntity instanceof IFastRenderMetaTileEntity) {
            return true;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior cover = this.metaTileEntity.getCoverAtSide(side);
            if (!(cover instanceof IFastRenderMetaTileEntity)) continue;
            return true;
        }
        return false;
    }

    public void setCustomName(String customName) {
        if (!this.func_70005_c_().equals(customName)) {
            this.customName = customName;
            if (this.field_145850_b.field_72995_K) {
                if (this.func_145818_k_()) {
                    if (this.nameTagParticle == null) {
                        this.nameTagParticle = new GTNameTagParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.func_70005_c_());
                        this.nameTagParticle.setOnUpdate(p -> {
                            if (this.func_145837_r() || !GTUtility.isPosChunkLoaded(this.func_145831_w(), this.func_174877_v())) {
                                p.func_187112_i();
                            }
                        });
                        GTParticleManager.INSTANCE.addEffect(this.nameTagParticle);
                    } else {
                        this.nameTagParticle.name = this.func_70005_c_();
                    }
                } else if (this.nameTagParticle != null) {
                    this.nameTagParticle.func_187112_i();
                    this.nameTagParticle = null;
                }
            } else {
                this.markAsDirty();
            }
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.customName == null ? "" : this.customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : (this.metaTileEntity != null ? new TextComponentTranslation(this.metaTileEntity.getMetaFullName(), new Object[0]) : new TextComponentString(this.func_70005_c_()));
    }

    @Nullable
    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(@Nonnull AEPartLocation part) {
        AENetworkProxy proxy = this.getProxy();
        return proxy == null ? null : proxy.getNode();
    }

    @Nonnull
    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(@Nonnull AEPartLocation part) {
        return this.metaTileEntity == null ? AECableType.NONE : this.metaTileEntity.getCableConnectionType(part);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    @Nonnull
    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        AENetworkProxy proxy = this.getProxy();
        return proxy == null ? null : proxy.getNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AENetworkProxy getProxy() {
        return this.metaTileEntity == null ? null : this.metaTileEntity.getProxy();
    }

    @Optional.Method(modid="appliedenergistics2")
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
        if (this.metaTileEntity != null) {
            this.metaTileEntity.gridChanged();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void readFromNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.readFromNBT(data);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void writeToNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.writeToNBT(data);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    void onChunkUnloadAE() {
        AENetworkProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.onChunkUnload();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    void invalidateAE() {
        AENetworkProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.invalidate();
        }
    }
}

