/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.collect.Multimap;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.IGTToolDefinition;
import gregtech.api.items.toolitem.ToolBuilder;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.util.LocalizationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGTAxe
extends ItemAxe
implements IGTTool {
    protected final String domain;
    protected final String id;
    protected final int tier;
    protected final IGTToolDefinition toolStats;
    protected final Set<String> toolClasses;
    protected final String oreDict;
    protected final SoundEvent sound;
    protected final boolean playSoundOnBlockDestroy;
    protected final Supplier<ItemStack> markerItem;

    protected ItemGTAxe(String domain, String id, int tier, IGTToolDefinition toolStats, SoundEvent sound, boolean playSoundOnBlockDestroy, Set<String> toolClasses, String oreDict, Supplier<ItemStack> markerItem) {
        super(Item.ToolMaterial.STONE, 0.0f, 0.0f);
        this.domain = domain;
        this.id = id;
        this.tier = tier;
        this.toolStats = toolStats;
        this.sound = sound;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.toolClasses = Collections.unmodifiableSet(toolClasses);
        this.oreDict = oreDict;
        this.markerItem = markerItem;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("gt.tool." + id + ".name");
        this.setRegistryName(domain, id);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isElectric() {
        return this.tier > -1;
    }

    @Override
    public int getElectricTier() {
        return this.tier;
    }

    @Override
    public IGTToolDefinition getToolStats() {
        return this.toolStats;
    }

    @Override
    @Nullable
    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public boolean playSoundOnBlockDestroy() {
        return this.playSoundOnBlockDestroy;
    }

    @Override
    public String getOreDictName() {
        return this.oreDict;
    }

    @Override
    @Nullable
    public Supplier<ItemStack> getMarkerItem() {
        return this.markerItem;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.definition$getSubItems(items);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return LocalizationUtils.format(this.func_77658_a(), this.getToolMaterial(stack).getLocalizedName());
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        return this.definition$getDestroySpeed(stack, state);
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        return this.definition$hitEntity(stack, target, attacker);
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.definition$onBlockStartBreak(itemstack, pos, player);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityLiving) {
        return this.definition$onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public int getItemEnchantability(@Nonnull ItemStack stack) {
        return this.getTotalEnchantability(stack);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.definition$getIsRepairable(toRepair, repair);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        return this.definition$getAttributeModifiers(slot, stack);
    }

    public int getHarvestLevel(@Nonnull ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        return this.definition$getHarvestLevel(stack, toolClass, player, blockState);
    }

    @Override
    @Nonnull
    public Set<String> getToolClasses(@Nonnull ItemStack stack) {
        return this.toolClasses;
    }

    public boolean canDisableShield(@Nonnull ItemStack stack, @Nonnull ItemStack shield, @Nonnull EntityLivingBase entity, @Nonnull EntityLivingBase attacker) {
        return this.definition$canDisableShield(stack, shield, entity, attacker);
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.definition$doesSneakBypassUse(stack, world, pos, player);
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        return this.definition$shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return this.definition$hasContainerItem(stack);
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        return this.definition$getContainerItem(stack);
    }

    public boolean onEntitySwing(@Nonnull EntityLivingBase entityLiving, @Nonnull ItemStack stack) {
        return this.definition$onEntitySwing(entityLiving, stack);
    }

    public boolean canDestroyBlockInCreative(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return this.definition$canDestroyBlockInCreative(world, pos, stack, player);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return this.definition$shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        return this.definition$isDamaged(stack);
    }

    public int getDamage(@Nonnull ItemStack stack) {
        return this.definition$getDamage(stack);
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return this.definition$getMaxDamage(stack);
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
        this.definition$setDamage(stack, damage);
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return this.definition$getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.definition$initCapabilities(stack, nbt);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        return this.definition$onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.definition$onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        return this.definition$onItemRightClick(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        this.definition$addInformation(stack, world, tooltip, flag);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        return this.definition$canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, @Nonnull ItemStack stack) {
        return ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack));
    }

    public static class Builder
    extends ToolBuilder<ItemGTAxe> {
        @Nonnull
        public static Builder of(@Nonnull String domain, @Nonnull String id) {
            return new Builder(domain, id);
        }

        public Builder(@Nonnull String domain, @Nonnull String id) {
            super(domain, id);
        }

        @Override
        public Supplier<ItemGTAxe> supply() {
            return () -> new ItemGTAxe(this.domain, this.id, this.tier, this.toolStats, this.sound, this.playSoundOnBlockDestroy, this.toolClasses, this.oreDict, this.markerItem);
        }
    }
}

