/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.gui;

import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryUIFactory;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerInventoryHolder
implements IUIHolder {
    public final EntityPlayer player;
    final EnumHand hand;
    ItemStack sampleItem;
    BooleanSupplier validityCheck;

    public static void openHandItemUI(EntityPlayer player, EnumHand hand) {
        PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
        holder.openUI();
    }

    @SideOnly(value=Side.CLIENT)
    public PlayerInventoryHolder(EntityPlayer player, EnumHand hand, ItemStack sampleItem) {
        this.player = player;
        this.hand = hand;
        this.sampleItem = sampleItem;
        this.validityCheck = () -> ItemStack.func_179545_c((ItemStack)sampleItem, (ItemStack)player.func_184586_b(hand));
    }

    public PlayerInventoryHolder(EntityPlayer entityPlayer, EnumHand hand) {
        this.player = entityPlayer;
        this.hand = hand;
        this.sampleItem = this.player.func_184586_b(hand);
        this.validityCheck = () -> ItemStack.func_179545_c((ItemStack)this.sampleItem, (ItemStack)this.player.func_184586_b(hand));
    }

    public PlayerInventoryHolder setCustomValidityCheck(BooleanSupplier validityCheck) {
        this.validityCheck = validityCheck;
        return this;
    }

    ModularUI createUI(EntityPlayer entityPlayer) {
        ItemUIFactory uiFactory = (ItemUIFactory)this.sampleItem.func_77973_b();
        return uiFactory.createUI(this, entityPlayer);
    }

    public void openUI() {
        PlayerInventoryUIFactory.INSTANCE.openUI(this, (EntityPlayerMP)this.player);
    }

    @Override
    public boolean isValid() {
        return this.validityCheck.getAsBoolean();
    }

    @Override
    public boolean isRemote() {
        return this.player.func_130014_f_().field_72995_K;
    }

    public ItemStack getCurrentItem() {
        ItemStack itemStack = this.player.func_184586_b(this.hand);
        if (!ItemStack.func_179545_c((ItemStack)this.sampleItem, (ItemStack)itemStack)) {
            return null;
        }
        return itemStack;
    }

    public void setCurrentItem(ItemStack item) {
        this.sampleItem = item;
        this.player.func_184611_a(this.hand, item);
    }

    @Override
    public void markAsDirty() {
        this.player.field_71071_by.func_70296_d();
        this.player.field_71069_bz.func_75142_b();
    }
}

