/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LabelWidget
extends Widget {
    protected boolean xCentered;
    protected boolean yCentered;
    protected int width;
    protected final String text;
    protected final Object[] formatting;
    private final int color;
    private boolean dropShadow;
    @SideOnly(value=Side.CLIENT)
    private List<String> texts;

    public LabelWidget(int xPosition, int yPosition, String text, Object ... formatting) {
        this(xPosition, yPosition, text, 0x404040, formatting);
    }

    public LabelWidget(int xPosition, int yPosition, String text, int color) {
        this(xPosition, yPosition, text, color, new Object[0]);
    }

    public LabelWidget(int xPosition, int yPosition, String text, int color, Object[] formatting) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.text = text;
        this.color = color;
        this.formatting = formatting;
        if (LabelWidget.isClientSide()) {
            this.texts = Collections.singletonList(this.getResultText());
        }
        this.recomputeSize();
    }

    public LabelWidget setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public LabelWidget setWidth(int width) {
        this.width = width;
        if (LabelWidget.isClientSide()) {
            this.texts = this.width > 0 ? Minecraft.func_71410_x().field_71466_p.func_78271_c(this.getResultText(), width) : Collections.singletonList(this.getResultText());
        }
        return this;
    }

    public LabelWidget setYCentered(boolean yCentered) {
        this.yCentered = yCentered;
        return this;
    }

    private String getResultText() {
        return I18n.func_135052_a((String)this.text, (Object[])this.formatting);
    }

    private void recomputeSize() {
        if (LabelWidget.isClientSide()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String resultText = this.getResultText();
            this.setSize(new Size(fontRenderer.func_78256_a(resultText), fontRenderer.field_78288_b));
            if (this.uiAccess != null) {
                this.uiAccess.notifySizeChange();
            }
        }
    }

    public LabelWidget setXCentered(boolean xCentered) {
        this.xCentered = xCentered;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position pos = this.getPosition();
        int height = fontRenderer.field_78288_b * this.texts.size();
        for (int i = 0; i < this.texts.size(); ++i) {
            String resultText = this.texts.get(i);
            int width = fontRenderer.func_78256_a(resultText);
            float x = (float)pos.x - (this.xCentered ? (float)width / 2.0f : 0.0f);
            float y = (float)pos.y - (this.yCentered ? (float)height / 2.0f : 0.0f) + (float)(i * fontRenderer.field_78288_b);
            fontRenderer.func_175065_a(resultText, x, y, this.color, this.dropShadow);
        }
    }
}

