/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.cover.ICoverable;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.terminal.hardware.HardwareProvider;
import gregtech.api.worldgen.generator.GTWorldGenCapability;
import gregtech.common.metatileentities.converter.ConverterTrait;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class SimpleCapabilityManager {
    public static <T> void registerCapabilityWithNoDefault(Class<T> capabilityClass) {
        CapabilityManager.INSTANCE.register(capabilityClass, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                throw new UnsupportedOperationException("Not supported");
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException("Not supported");
            }
        }, () -> {
            throw new UnsupportedOperationException("This capability has no default implementation");
        });
    }

    public static void init() {
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IEnergyContainer.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IElectricItem.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IWorkable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(ICoverable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IControllable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IActiveOutputSide.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IFuelable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IMultiblockController.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IMaintenance.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IMultipleRecipeMaps.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(AbstractRecipeLogic.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(HardwareProvider.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(ConverterTrait.class);
        CapabilityManager.INSTANCE.register(GTWorldGenCapability.class, GTWorldGenCapability.STORAGE, GTWorldGenCapability.FACTORY);
    }
}

