/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.Multimap;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.ILeftClickHandler;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.entity.chunkdata.EntityChunkData;
import com.rwtema.extrautils2.interblock.FlatTransferNodeHandler;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlatTransferNode
extends XUItemFlatMetadata
implements ILeftClickHandler {
    public static final String ITEM_TEXTURE = "transfernodes/flat_transfernode_items";
    public static final String FLUID_TEXTURE = "transfernodes/flat_transfernode_fluids";
    public static final String SELECTION_TEXTURE = "transfernodes/flat_transfernode_selection";
    public static final String BACK_TEXTURE = "transfernodes/flat_transfernode_back";

    public ItemFlatTransferNode() {
        super(ITEM_TEXTURE, FLUID_TEXTURE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public static FlatTransferNodeHandler.FlatTransferNode getCurrentFlatTransferNode(EntityPlayer player) {
        int length = 5;
        Vec3d startPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d endPos = startPos.func_72441_c(player.func_70040_Z().field_72450_a * (double)length, player.func_70040_Z().field_72448_b * (double)length, player.func_70040_Z().field_72449_c * (double)length);
        int cx0 = (int)Math.floor(Math.min(startPos.field_72450_a, endPos.field_72450_a)) >> 4;
        int cz0 = (int)Math.floor(Math.min(startPos.field_72449_c, endPos.field_72449_c)) >> 4;
        int cx1 = (int)Math.ceil(Math.max(startPos.field_72450_a, endPos.field_72450_a)) >> 4;
        int cz1 = (int)Math.ceil(Math.max(startPos.field_72449_c, endPos.field_72449_c)) >> 4;
        double bestDist = -1.0;
        FlatTransferNodeHandler.FlatTransferNode bestDistNode = null;
        World world = player.func_130014_f_();
        for (int cx = cx0; cx <= cx1; ++cx) {
            for (int cz = cz0; cz <= cz1; ++cz) {
                Multimap<BlockPos, FlatTransferNodeHandler.FlatTransferNode> chunkData = EntityChunkData.getChunkData(world.func_72964_e(cx, cz), FlatTransferNodeHandler.INSTANCE, false);
                for (FlatTransferNodeHandler.FlatTransferNode node : chunkData.values()) {
                    double d;
                    AxisAlignedBB bounds = node.getBounds();
                    RayTraceResult ray = bounds.func_72327_a(startPos, endPos);
                    if (ray == null || !((d = startPos.func_72436_e(ray.field_72307_f)) < bestDist) && bestDist != -1.0) continue;
                    bestDist = d;
                    bestDistNode = node;
                }
            }
        }
        return bestDistNode;
    }

    @Override
    public boolean renderLayerIn3D(ItemStack stack, int renderPass) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        Textures.register(SELECTION_TEXTURE);
        Textures.register(BACK_TEXTURE);
    }

    @Override
    public EnumActionResult onItemUseFirstBase(ItemStack stack, EntityPlayer player, World world, final BlockPos pos, final EnumFacing side, final float hitX, final float hitY, final float hitZ, final EnumHand hand) {
        FlatTransferNodeHandler.FlatTransferNode.Type type;
        FlatTransferNodeHandler.FlatTransferNode node;
        if (world.field_72995_K) {
            ExtraUtils2.proxy.run(new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    NetHandlerPlayClient connection = Minecraft.func_71410_x().func_147114_u();
                    if (connection != null) {
                        connection.func_147297_a((Packet)new CPacketPlayerTryUseItemOnBlock(pos, side, hand, hitX, hitY, hitZ));
                    }
                }
            });
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_70093_af() && (node = ItemFlatTransferNode.getCurrentFlatTransferNode(player)) != null) {
            player.openGui((Object)ExtraUtils2.instance, FlatTransferNodeHandler.guiIdSides[node.side.ordinal()], world, node.pos.func_177958_n(), node.pos.func_177956_o(), node.pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && ((type = FlatTransferNodeHandler.FlatTransferNode.Type.values()[stack.func_77960_j() % 2]) == FlatTransferNodeHandler.FlatTransferNode.Type.ITEM && CapGetter.ItemHandler.hasInterface((ICapabilityProvider)te, side) || type == FlatTransferNodeHandler.FlatTransferNode.Type.FLUIDS && CapGetter.FluidHandler.hasInterface((ICapabilityProvider)te, side))) {
            FlatTransferNodeHandler.FlatTransferNode newNode = new FlatTransferNodeHandler.FlatTransferNode(pos.func_185334_h(), side, type, !ExtraUtils2.proxy.isAltSneaking(player));
            Chunk chunk = world.func_175726_f(pos);
            boolean flag = false;
            for (FlatTransferNodeHandler.FlatTransferNode node2 : EntityChunkData.getChunkData(chunk, FlatTransferNodeHandler.INSTANCE, false).get((Object)pos)) {
                if (node2.side != side) continue;
                flag = true;
                break;
            }
            if (!flag) {
                EntityChunkData.getChunkData(chunk, FlatTransferNodeHandler.INSTANCE, true).put((Object)newNode.pos, (Object)newNode);
                EntityChunkData.markChunkDirty(chunk);
                if (!player.field_71075_bZ.field_75098_d) {
                    StackHelper.decrease(stack);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SubscribeEvent
    public void run(PlayerInteractEvent.RightClickBlock event) {
    }

    @Override
    public boolean leftClick(World world, EntityPlayer player, ItemStack stack) {
        FlatTransferNodeHandler.FlatTransferNode node = ItemFlatTransferNode.getCurrentFlatTransferNode(player);
        if (node == null) {
            return false;
        }
        if (!world.field_72995_K) {
            node.isDead = true;
            Chunk chunk = world.func_175726_f(node.pos);
            Multimap<BlockPos, FlatTransferNodeHandler.FlatTransferNode> chunkData = EntityChunkData.getChunkData(chunk, FlatTransferNodeHandler.INSTANCE, false);
            if (chunkData != null && chunkData.remove((Object)node.pos, (Object)node)) {
                node.dropItemStack(world);
                EntityChunkData.markChunkDirty(chunk);
            }
        }
        return true;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return super.func_77667_c(stack) + ".item";
            }
            case 1: {
                return super.func_77667_c(stack) + ".fluid";
            }
        }
        return super.func_77667_c(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, playerIn, tooltip, advanced);
        tooltip.add(Lang.translate("Thinner than the thinnest of pancakes."));
        tooltip.add(Lang.translate("Small enough to fit between blocks."));
        tooltip.add("");
        tooltip.add(Lang.translateArgs("Hold %s when placing to reverse push/pull.", Minecraft.func_71410_x().field_71474_y.field_151444_V.getDisplayName()));
    }
}

