/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.api.items;

import com.zook.devtech.common.items.DTMetaItem;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.items.metaitem.ElectricStats;
import gregtech.api.items.metaitem.FluidStats;
import gregtech.api.items.metaitem.FoodStats;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemComponent;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.MetaItem")
@ZenRegister
public class MetaItem {
    private final MetaItem.MetaValueItem item;

    public MetaItem(MetaItem.MetaValueItem item) {
        this.item = item;
    }

    @Nullable
    @ZenMethod
    public static MetaItem getByName(String name) {
        for (gregtech.api.items.metaitem.MetaItem metaItem : gregtech.api.items.metaitem.MetaItem.getMetaItems()) {
            MetaItem.MetaValueItem metaValueItem = metaItem.getItem(name);
            if (metaValueItem == null) continue;
            return new MetaItem(metaValueItem);
        }
        return null;
    }

    @ZenMethod(value="create")
    public static MetaItem addItem(short id, String name) {
        return new MetaItem(DTMetaItem.META_ITEM.addItem(id, name));
    }

    @ZenMethod
    public MetaItem setModel(String location) {
        return this;
    }

    @ZenMethod
    public MetaItem foodStats(int foodLevel, float saturation, @Optional boolean isDrink) {
        this.item.addComponents(new IItemComponent[]{new FoodStats(foodLevel, saturation, isDrink)});
        return this;
    }

    @ZenMethod
    public MetaItem electricItem(long maxCharge, int tier, @Optional(valueBoolean=true) boolean rechargeable, @Optional(valueBoolean=true) boolean dischrgeable) {
        this.item.addComponents(new IItemComponent[]{new ElectricStats(maxCharge, (long)tier, rechargeable, dischrgeable)});
        return this;
    }

    @ZenMethod
    public MetaItem fluidItem(int maxCapacity, @Optional boolean gasProof, @Optional boolean acidProof, @Optional boolean cryoProof, @Optional boolean plasmaProof, @Optional(valueBoolean=true) boolean allowPartlyFill, @Optional(valueLong=0x7FFFFFFFL) int maxFluidTemperature) {
        this.item.addComponents(new IItemComponent[]{new FluidStats(maxCapacity, maxFluidTemperature, gasProof, acidProof, cryoProof, plasmaProof, allowPartlyFill)});
        return this;
    }

    @ZenMethod
    public MetaItem oreDict(String oreDictName) {
        this.item.addOreDict(oreDictName);
        return this;
    }

    @ZenMethod
    public MetaItem invisible() {
        this.item.setInvisible();
        return this;
    }

    @ZenMethod
    public MetaItem stackSize(int maxStackSize) {
        this.item.setMaxStackSize(maxStackSize);
        return this;
    }

    @ZenMethod
    public MetaItem burnTime(int burnValue) {
        this.item.setBurnValue(burnValue);
        return this;
    }
}

