/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AppEngInternalOversizedInventory
extends AppEngInternalInventory {
    public AppEngInternalOversizedInventory(IAEAppEngInventory inventory, int size, int maxStack, IAEItemFilter filter) {
        super(inventory, size, maxStack, filter);
    }

    public AppEngInternalOversizedInventory(IAEAppEngInventory inventory, int size, int maxStack) {
        super(inventory, size, maxStack);
    }

    public AppEngInternalOversizedInventory(IAEAppEngInventory inventory, int size) {
        super(inventory, size);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (this.filter != null && !this.filter.allowInsert((IItemHandler)this, slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.maxStack[slot];
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.filter != null && !this.filter.allowExtract((IItemHandler)this, slot, amount)) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        if (this.limitExtraction) {
            return super.extractItem(slot, amount, simulate);
        }
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (existing.func_190916_E() <= amount) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - amount)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)amount);
    }

    @Override
    public void forEach(Consumer<? super ItemStack> consumer) {
        super.forEach(consumer);
    }

    @Override
    public Spliterator<ItemStack> spliterator() {
        return super.spliterator();
    }
}

