/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.trashslot.CommonProxy;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.api.TrashSlotAPI;
import net.blay09.mods.trashslot.client.SlotTrash;
import net.blay09.mods.trashslot.client.TrashClient;
import net.blay09.mods.trashslot.client.TrashContainerSettings;
import net.blay09.mods.trashslot.client.deletion.CreativeDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DefaultDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.GuiHelper;
import net.blay09.mods.trashslot.client.gui.GuiTrashSlot;
import net.blay09.mods.trashslot.client.gui.layout.ChestContainerLayout;
import net.blay09.mods.trashslot.client.gui.layout.SimpleGuiContainerLayout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static TextureAtlasSprite trashSlotIcon;
    private final KeyBinding keyBindToggleSlot = new KeyBinding("key.trashslot.toggle", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 20, "key.categories.trashslot");
    private final KeyBinding keyBindDelete = new KeyBinding("key.trashslot.delete", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 211, "key.categories.trashslot");
    private final KeyBinding keyBindDeleteAll = new KeyBinding("key.trashslot.deleteAll", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, 211, "key.categories.trashslot");
    private final SlotTrash trashSlot = new SlotTrash();
    private boolean sentMissingMessage;
    private long missingMessageTime;
    private GuiTrashSlot guiTrashSlot;
    private TrashContainerSettings currentSettings = TrashContainerSettings.NONE;
    private DeletionProvider deletionProvider;
    private boolean ignoreMouseUp;

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBindToggleSlot);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBindDelete);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBindDeleteAll);
        TrashSlotAPI.registerLayout(GuiInventory.class, SimpleGuiContainerLayout.DEFAULT_ENABLED);
        TrashSlotAPI.registerLayout(GuiCrafting.class, SimpleGuiContainerLayout.DEFAULT_ENABLED);
        TrashSlotAPI.registerLayout(GuiChest.class, new ChestContainerLayout());
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        trashSlotIcon = event.getMap().func_174942_a(new ResourceLocation("trashslot", "items/trashcan"));
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            this.currentSettings = TrashContainerSettings.NONE;
            this.guiTrashSlot = null;
            return;
        }
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            if (this.deletionProvider == null) {
                if (TrashSlot.isServerSideInstalled) {
                    this.deletionProvider = TrashSlot.instantDeletion ? new CreativeDeletionProvider() : new DefaultDeletionProvider();
                } else {
                    if (!this.sentMissingMessage) {
                        this.missingMessageTime = System.currentTimeMillis();
                        this.sentMissingMessage = true;
                    }
                    return;
                }
            }
            if (gui instanceof GuiInventory && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                return;
            }
            IGuiContainerLayout layout = TrashClient.getLayout(gui);
            this.currentSettings = TrashClient.getSettings(gui, layout);
            this.guiTrashSlot = this.currentSettings != TrashContainerSettings.NONE ? new GuiTrashSlot(gui, layout, this.currentSettings, this.trashSlot) : null;
        } else {
            this.currentSettings = TrashContainerSettings.NONE;
            this.guiTrashSlot = null;
        }
    }

    @SubscribeEvent
    public void onGuiMouse(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!this.currentSettings.isEnabled()) {
            return;
        }
        int mouseButton = Mouse.getEventButton();
        boolean buttonState = Mouse.getEventButtonState();
        if (this.ignoreMouseUp && !buttonState && mouseButton != -1) {
            event.setCanceled(true);
            this.ignoreMouseUp = false;
            return;
        }
        if (event.getGui() instanceof GuiContainer && buttonState) {
            int mouseY;
            GuiContainer gui = (GuiContainer)event.getGui();
            ScaledResolution resolution = new ScaledResolution(gui.field_146297_k);
            int scaledWidth = resolution.func_78326_a();
            int scaledHeight = resolution.func_78328_b();
            int mouseX = Mouse.getX() * scaledWidth / gui.field_146297_k.field_71443_c;
            if (gui.func_146981_a((Slot)this.trashSlot, mouseX, mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.field_146297_k.field_71440_d - 1)) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    boolean isRightClick;
                    ItemStack mouseItem = player.field_71071_by.func_70445_o();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.func_190926_b()) {
                        this.deletionProvider.undeleteLast((EntityPlayer)player, this.trashSlot, isRightClick);
                    } else {
                        this.deletionProvider.deleteMouseItem((EntityPlayer)player, mouseItem, this.trashSlot, isRightClick);
                    }
                    event.setCanceled(true);
                    this.ignoreMouseUp = true;
                }
            } else if (this.guiTrashSlot.isInside(mouseX, mouseY)) {
                event.setCanceled(true);
                this.ignoreMouseUp = true;
            }
        }
    }

    @SubscribeEvent
    public void onGuiKeyboard(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (Keyboard.getEventKeyState()) {
            int keyCode = Keyboard.getEventKey();
            if (this.currentSettings.isEnabled() && this.deletionProvider != null) {
                EntityPlayerSP entityPlayer;
                boolean isDelete = this.keyBindDelete.isActiveAndMatches(keyCode);
                boolean isDeleteAll = this.keyBindDeleteAll.isActiveAndMatches(keyCode);
                if ((isDelete || isDeleteAll) && (entityPlayer = Minecraft.func_71410_x().field_71439_g) != null && event.getGui() instanceof GuiContainer) {
                    GuiContainer gui = (GuiContainer)event.getGui();
                    Slot mouseSlot = gui.getSlotUnderMouse();
                    if (mouseSlot != null && mouseSlot.func_75216_d()) {
                        this.deletionProvider.deleteContainerItem(gui.field_147002_h, mouseSlot.field_75222_d, isDeleteAll);
                    } else {
                        int mouseY;
                        ScaledResolution resolution = new ScaledResolution(gui.field_146297_k);
                        int scaledWidth = resolution.func_78326_a();
                        int scaledHeight = resolution.func_78328_b();
                        int mouseX = Mouse.getX() * scaledWidth / gui.field_146297_k.field_71443_c;
                        if (gui.func_146981_a((Slot)this.trashSlot, mouseX, mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.field_146297_k.field_71440_d - 1)) {
                            this.deletionProvider.emptyTrashSlot(this.trashSlot);
                        }
                    }
                }
            }
            if (event.getGui() instanceof GuiContainer && this.currentSettings != TrashContainerSettings.NONE && this.keyBindToggleSlot.isActiveAndMatches(keyCode)) {
                this.currentSettings.setEnabled(!this.currentSettings.isEnabled());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!this.currentSettings.isEnabled()) {
            return;
        }
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            if (this.guiTrashSlot != null) {
                this.guiTrashSlot.update(event.getMouseX(), event.getMouseY());
                this.guiTrashSlot.drawBackground(event.getMouseX(), event.getMouseY());
                if (gui.func_146981_a((Slot)this.trashSlot, event.getMouseX(), event.getMouseY())) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    int j1 = gui.getGuiLeft() + this.trashSlot.field_75223_e;
                    int k1 = gui.getGuiTop() + this.trashSlot.field_75221_f;
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    GuiHelper.drawGradientRect(j1, k1, j1 + 16, k1 + 16, -600.0f, -2130706433, -2130706433);
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GlStateManager.func_179126_j();
                }
            }
        }
    }

    @SubscribeEvent
    public void onBackgroundDrawn(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            if (this.missingMessageTime != 0L && System.currentTimeMillis() - this.missingMessageTime < 3000L) {
                String noHabloEspanol = TextFormatting.RED + I18n.func_135052_a((String)"trashslot.serverNotInstalled", (Object[])new Object[0]);
                GuiUtils.drawHoveringText((List)Lists.newArrayList((Object[])new String[]{noHabloEspanol}), (int)(gui.getGuiLeft() + gui.getXSize() / 2 - gui.field_146297_k.field_71466_p.func_78256_a(noHabloEspanol) / 2), (int)25, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)gui.field_146297_k.field_71466_p);
            }
            if (!this.currentSettings.isEnabled()) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)gui.getGuiLeft(), (float)gui.getGuiTop(), (float)0.0f);
            RenderHelper.func_74520_c();
            gui.func_146977_a((Slot)this.trashSlot);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            if (!this.currentSettings.isEnabled()) {
                return;
            }
            boolean isMouseSlot = gui.func_146981_a((Slot)this.trashSlot, event.getMouseX(), event.getMouseY());
            InventoryPlayer inventoryPlayer = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            if (isMouseSlot && inventoryPlayer.func_70445_o().func_190926_b() && this.trashSlot.func_75216_d()) {
                gui.func_146285_a(this.trashSlot.func_75211_c(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    @Override
    @Nullable
    public DeletionProvider getDeletionProvider() {
        return this.deletionProvider;
    }

    @Override
    public SlotTrash getTrashSlot() {
        return this.trashSlot;
    }

    @Nullable
    public GuiTrashSlot getGuiTrashSlot() {
        return this.guiTrashSlot;
    }

    @Override
    public void reloadDeletionProvider() {
        this.deletionProvider = null;
    }
}

